------------------------------------------------------------------------------
--                                                                          --
--                      S Y S T E M . C . S T R L E N                       --
--                                                                          --
--                                 S p e c                                  --
--                                                                          --
--                       Copyright (C) 2013, AdaCore                        --
--                                                                          --
-- GNAT is free software;  you can  redistribute it  and/or modify it under --
-- terms of the  GNU General Public License as published  by the Free Soft- --
-- ware  Foundation;  either version 3,  or (at your option) any later ver- --
-- sion.  GNAT is distributed in the hope that it will be useful, but WITH- --
-- OUT ANY WARRANTY;  without even the  implied warranty of MERCHANTABILITY --
-- or FITNESS FOR A PARTICULAR PURPOSE.                                     --
--                                                                          --
--                                                                          --
--                                                                          --
--                                                                          --
--                                                                          --
-- You should have received a copy of the GNU General Public License and    --
-- a copy of the GCC Runtime Library Exception along with this program;     --
-- see the files COPYING3 and COPYING.RUNTIME respectively.  If not, see    --
-- <http://www.gnu.org/licenses/>.                                          --
--                                                                          --
-- GNAT was originally developed  by the GNAT team at  New York University. --
-- Extensive contributions were provided by Ada Core Technologies Inc.      --
--                                                                          --
------------------------------------------------------------------------------

package body System.C.Strlen is

   type C_String is array (size_t) of Character;

   ------------
   -- strlen --
   ------------

   function strlen (Str : Address) return size_t is
      str_p : C_String;
      for str_p'Address use Str;
      pragma Import (Ada, str_p);

   begin
      for J in str_p'Range loop
         if str_p (J) = ASCII.NUL then
            return J;
         end if;
      end loop;

      return size_t'Last;
   end strlen;

end System.C.Strlen;
