------------------------------------------------------------------------------
--                                                                          --
--                         GNAT COMPILER COMPONENTS                         --
--                                                                          --
--                           I N T E R F A C E S                            --
--                                                                          --
--                                 S p e c                                  --
--                                                                          --
--          Copyright (C) 2002-2014, Free Software Foundation, Inc.         --
--                                                                          --
-- This specification is derived from the Ada Reference Manual for use with --
-- GNAT. The copyright notice above, and the license provisions that follow --
-- apply solely to the implementation dependent sections of this file.      --
--                                                                          --
-- GNAT is free software;  you can  redistribute it  and/or modify it under --
-- terms of the  GNU General Public License as published  by the Free Soft- --
-- ware  Foundation;  either version 3,  or (at your option) any later ver- --
-- sion.  GNAT is distributed in the hope that it will be useful, but WITH- --
-- OUT ANY WARRANTY;  without even the  implied warranty of MERCHANTABILITY --
-- or FITNESS FOR A PARTICULAR PURPOSE.                                     --
--                                                                          --
--                                                                          --
--                                                                          --
--                                                                          --
--                                                                          --
-- You should have received a copy of the GNU General Public License and    --
-- a copy of the GCC Runtime Library Exception along with this program;     --
-- see the files COPYING3 and COPYING.RUNTIME respectively.  If not, see    --
-- <http://www.gnu.org/licenses/>.                                          --
--                                                                          --
-- GNAT was originally developed  by the GNAT team at  New York University. --
-- Extensive contributions were provided by Ada Core Technologies Inc.      --
--                                                                          --
------------------------------------------------------------------------------

--  This is the AVR version of this package

package Interfaces is
   pragma Pure;

   --  All identifiers in this unit are implementation defined

   pragma Implementation_Defined;

   type Integer_8  is range -2 **  7 .. 2 **  7 - 1;
   for Integer_8'Size use  8;

   type Integer_16 is range -2 ** 15 .. 2 ** 15 - 1;
   for Integer_16'Size use 16;

   type Integer_32 is range -2 ** 31 .. 2 ** 31 - 1;
   for Integer_32'Size use 32;

   type Integer_64 is range -2 ** 63 .. 2 ** 63 - 1;
   for Integer_64'Size use 64;

   type Unsigned_8  is mod 2 **  8;
   for Unsigned_8'Size use  8;
   pragma Provide_Shift_Operators (Unsigned_8);

   type Unsigned_16 is mod 2 ** 16;
   for Unsigned_16'Size use 16;
   pragma Provide_Shift_Operators (Unsigned_16);

   type Unsigned_32 is mod 2 ** 32;
   for Unsigned_32'Size use 32;
   pragma Provide_Shift_Operators (Unsigned_32);

   type Unsigned_64 is mod 2 ** 64;
   for Unsigned_64'Size use 64;
   pragma Provide_Shift_Operators (Unsigned_64);

   --  IEEE Floating point types

   type IEEE_Float_32 is digits 6;
   for IEEE_Float_32'Size use 32;

   --  Note: The following type can't be compiled on AVR, because the
   --  largest AVR floating-point type is 32 bits. It would be confusing
   --  and misleading to provide this type on a target without 64-bit
   --  floating-point support, so it's commented out in the AVR version
   --  of this unit.

   --  type IEEE_Float_64 is digits 15;
   --  for IEEE_Float_64;

   --  There is no IEEE extended float available on the machine, but we still
   --  define the synonym for Long_Long_Float to accomodate code that uses this
   --  type as a way of specifying the largest available floating-point type.

   --  Note: it is harmless, and explicitly permitted, to include additional
   --  types in interfaces, so it is not wrong to have IEEE_Extended_Float
   --  defined even if the extended format is not available.

   type IEEE_Extended_Float is new Long_Long_Float;

end Interfaces;
