------------------------------------------------------------------------------
--                                                                          --
--                         GNAT RUN-TIME COMPONENTS                         --
--                                                                          --
--                          G N A T . I O . P U T                           --
--                                                                          --
--                                 B o d y                                  --
--                                                                          --
--                       Copyright (C) 2012, AdaCore                        --
--                                                                          --
-- GNAT is free software;  you can  redistribute it  and/or modify it under --
-- terms of the  GNU General Public License as published  by the Free Soft- --
-- ware  Foundation;  either version 3,  or (at your option) any later ver- --
-- sion.  GNAT is distributed in the hope that it will be useful, but WITH- --
-- OUT ANY WARRANTY;  without even the  implied warranty of MERCHANTABILITY --
-- or FITNESS FOR A PARTICULAR PURPOSE.                                     --
--                                                                          --
--                                                                          --
--                                                                          --
--                                                                          --
--                                                                          --
-- You should have received a copy of the GNU General Public License and    --
-- a copy of the GCC Runtime Library Exception along with this program;     --
-- see the files COPYING3 and COPYING.RUNTIME respectively.  If not, see    --
-- <http://www.gnu.org/licenses/>.                                          --
--                                                                          --
-- GNAT was originally developed  by the GNAT team at  New York University. --
-- Extensive contributions were provided by Ada Core Technologies Inc.      --
--                                                                          --
------------------------------------------------------------------------------

--  LEON version of text output routine

with System;

separate (GNAT.IO)
procedure Put (C : Character) is
   type Register is mod 2**32;

   UART_Data   : Register;
   UART_Status : Register;
   --  Comment these ???

   for UART_Data'Address   use System'To_Address (16#8000_0070#);
   for UART_Status'Address use System'To_Address (16#8000_0074#);

   pragma Volatile (UART_Data);
   pragma Volatile (UART_Status);

begin
   --  Need some comments of what is going on here ???

   while (UART_Status and 4) = 0 loop
      null;
   end loop;

   UART_Data := Character'Pos (C);
end Put;
