--  This program illustrates using the dimensioned units facility with no
--  dimensionality checking enforced. There is no additional run-time overhead,
--  apart from the need to call the function Value occasionally.
--
--  The program uses an instantiation of a different generic package that has
--  the same interface presented by the dimensioned units package and the metric
--  system child package. In particular, the client calculation code itself is
--  unchanged; only the context clause is different and that could be almost
--  identical as well by using the same package names for the instantiation (one
--  less package is required also).

with Float_Metric_Units;   use Float_Metric_Units;
with Ada.Text_IO;          use Ada.Text_IO;

procedure Demo_Unchecked is

   M : Mass := 1.0 * Kilogram;
   E : Erg := M * C**2;

begin
   Put_Line (Float'Image (Value (E)));
end Demo_Unchecked;

