--  This package is intended to provide the same interface as that of the
--  dimensioned unit generic and the generic child unit defining the metric
--  system constants, but without incurring run-time checking.
--
--  The idea is to use the dimensioned units package and the metric units child
--  package during development and then to replace those packages with this one
--  for the release.

generic
   type Real is digits <>;
package Dimensionless_GCS_Metric_System is

   Dimension_Error : exception;

   subtype Speed is Real;
   subtype Erg   is Real;

   subtype Mass     is Real;
   subtype Distance is Real;
   subtype Time     is Real;
   subtype Scalar   is Real;

   Gram       : constant Mass;
   Centimeter : constant Distance;
   Second     : constant Time;

   Millimeter : constant Distance;
   Kilogram   : constant Mass;
   Meter      : constant Distance;
   Kilometer  : constant Distance;
   Minute     : constant Time;
   Hour       : constant Time;

   C          : constant Speed;

   function Value (Left : Real) return Real;

private

   Gram       : constant Mass     := 1.0;
   Centimeter : constant Distance := 1.0;
   Second     : constant Time     := 1.0;

   Millimeter : constant Distance :=    0.1 * Centimeter;
   Kilogram   : constant Mass     := 1000.0 * Gram;
   Meter      : constant Distance := 1000.0 * Millimeter;
   Kilometer  : constant Distance := 1000.0 * Meter;
   Minute     : constant Time     :=   60.0 * Second;
   Hour       : constant Time     :=   60.0 * Minute;

   C          : constant Speed := 300_000_000.0 * (Meter/Second);

end Dimensionless_GCS_Metric_System;

