--  This package defines subtypes and constant units for the metric system. The
--  values for grams, centimeters, and seconds are the unitary values, with the
--  other values defined as multiples or fractions of those values.
--
--  Alternative unitary values could be defined by other generic packages. For
--  example, a package could be defined so that kilograms, meters, and hours
--  would be the basis for defining the other values.

generic
package Dimensioned_Units.GCS_Metric_System is

   subtype Speed    is Unit (M => 0, D => 1, T => -1);
   subtype Erg      is Unit (M => 1, D => 2, T => -2);

   Gram       : constant Mass;
   Centimeter : constant Distance;
   Second     : constant Time;

   Kilogram   : constant Mass;
   Millimeter : constant Distance;
   Meter      : constant Distance;
   Kilometer  : constant Distance;
   Minute     : constant Time;
   Hour       : constant Time;

   C          : constant Speed;

private

   Gram       : constant Mass     := Make (1.0, 1, 0, 0);
   Centimeter : constant Distance := Make (1.0, 0, 1, 0);
   Second     : constant Time     := Make (1.0, 0, 0, 1);

   Millimeter : constant Distance :=    0.1 * Centimeter;
   Kilogram   : constant Mass     := 1000.0 * Gram;
   Meter      : constant Distance := 1000.0 * Millimeter;
   Kilometer  : constant Distance := 1000.0 * Meter;
   Minute     : constant Time     :=   60.0 * Second;
   Hour       : constant Time     :=   60.0 * Minute;

   C          : constant Speed := 300_000_000.0 * (Meter/Second);

end Dimensioned_Units.GCS_Metric_System;

