------------------------------------------------------------------------------
--                                                                          --
--                         GNAT RUN-TIME COMPONENTS                         --
--                                                                          --
--                              G N A T . I O                               --
--                                                                          --
--                                 B o d y                                  --
--                                                                          --
--                     Copyright (C) 1995-2006, AdaCore                     --
--                                                                          --
-- GNAT is free software;  you can  redistribute it  and/or modify it under --
-- terms of the  GNU General Public License as published  by the Free Soft- --
-- ware  Foundation;  either version 2,  or (at your option) any later ver- --
-- sion.  GNAT is distributed in the hope that it will be useful, but WITH- --
-- OUT ANY WARRANTY;  without even the  implied warranty of MERCHANTABILITY --
-- or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License --
-- for  more details.  You should have  received  a copy of the GNU General --
-- Public License  distributed with GNAT;  see file COPYING.  If not, write --
-- to  the  Free Software Foundation,  51  Franklin  Street,  Fifth  Floor, --
-- Boston, MA 02110-1301, USA.                                              --
--                                                                          --
--
--
--
--
--
--
--
-- GNAT was originally developed  by the GNAT team at  New York University. --
-- Extensive contributions were provided by Ada Core Technologies Inc.      --
--                                                                          --
------------------------------------------------------------------------------

--  vxworks zfp version of Put (C : Character)

with Interfaces.C; use Interfaces.C;

separate (GNAT.IO)
procedure Put (C : Character) is

   function ioGlobalStdGet
     (File : int) return int;
   pragma Import (C, ioGlobalStdGet, "ioGlobalStdGet");

   procedure fdprintf
     (File   : int;
      Format : String;
      Value  : Character);
   pragma Import (C, fdprintf, "fdprintf");

   Stdout_ID : constant int := 1;

begin
   fdprintf (ioGlobalStdGet (Stdout_ID), "%c" & ASCII.NUL, C);
end Put;
