with Ada.Text_IO;         use Ada.Text_IO;
with Ada.Integer_Text_IO; use Ada.Integer_Text_IO;
with Dash_Board;

package body Speedometer is

   -------------
   -- Display --
   -------------

   procedure Display (This : access Digital_Speedometer) is
   begin
      InDash.Instrument_Reference (This).Display;
      Put (Integer (This.Value), 3);
      Put (" Miles per Hour");
   end Display;

   ------------
   -- Update --
   ------------

   procedure Update (This : access Digital_Speedometer; Millisec : Integer) is
   begin
      -- speed grows at 2mph per 15 seconds
      This.Value := This.Value + 2.0 * (Float(Millisec) / 1000.0 / 15.0);
   end Update;

   ------------------------------
   -- Make_Digital_Speedometer --
   ------------------------------

   function Make_Digital_Speedometer (Name : String; Value : Speed) 
      return Digital_Speedometer_Reference 
   is
      Result : Digital_Speedometer_Reference;
   begin
      Result := new Digital_Speedometer;
      Result.Set_Name (Name);
      Result.Value := Value;
      return Result;
   end Make_Digital_Speedometer;


   use InDash;
begin
   Dash_Board.Register (Any_Instrument (Make_Digital_Speedometer ("Speed", 45.0)));
end Speedometer;
