with Dash_Board;
with Hashed_Strings;
with Plugins;               use Plugins;
with Extension;             use Extension;
with Ada.Text_IO;           use Ada.Text_IO;
with Ada.Integer_Text_IO;   use Ada.Integer_Text_IO;
with Ada.Directories;       use Ada.Directories;
with Ada.Strings.Unbounded; use Ada.Strings.Unbounded;

procedure Demo is

   Increment : Integer;
   --  elapsed time in milliseconds

   Loaded_DLLs : Hashed_Strings.Set := Hashed_Strings.Empty_Set;
   --  the names of all currently discovered plug-ins

  function "+" (Source : String)  return Unbounded_String
     renames To_Unbounded_String;


   procedure Discover_Plugins is
      S, S1      : Search_Type;
      D, D1      : Directory_Entry_Type;
      Only_Dirs  : constant Filter_Type := (Directory     => True, others => False);
      Only_Files : constant Filter_Type := (Ordinary_File => True, others => False);
      Base       : constant String := "base." & Extension.File_Extension;
      Any_Plugin : constant String := "*." & Extension.File_Extension;
      use Hashed_Strings;
   begin
      Start_Search (S, ".", "", Only_Dirs);
      while More_Entries (S) loop
         Get_Next_Entry (S, D);
         Start_Search (S1, Full_Name (D), Any_Plugin, Only_Files);
         while More_Entries (S1) loop
            Get_Next_Entry (S1, D1);
            declare
               P     : Plugin;
               Name  : constant String := Simple_Name (D1);
               Fname : constant String := Full_Name (D1);
            begin
               if Name (Name'Last - Base'Length + 1 .. Name'Last) /= Base
                 and then not Contains (Loaded_DLLs, +Fname)
               then
                  P := Plugins.Load (Fname);
                  Loaded_DLLs.Insert (+Fname);
               end if;
            end;
         end loop;
      end loop;
   end Discover_Plugins;

begin
   Put ("Give a time increment in milliseconds (0 to abandon): ");
   Get (Increment);
   if Increment <= 0 then
      return;
   end if;
   loop
      Discover_Plugins;
      Dash_Board.Display;
      Dash_Board.Update (Increment);
      delay Duration (Increment/1000);
   end loop;
end Demo;
