with Ada.Text_IO;

package body Dash_Board is

   procedure Register (Device : InDash.Any_Instrument) is
   begin
      Registry.Append (Device);
   end Register;


   use Instruments;


   procedure Display is
      C : Cursor := First (Registry);
   begin
      while C /= No_Element loop
         Element (C).Display; -- dispatches
         Next (C);
      end loop;
      Ada.Text_IO.New_Line;
   end Display;

   procedure Update (Millisec : Integer) is
      C : Cursor := First (Registry);
   begin
      while C /= No_Element loop
         Element (C).Update (Millisec); -- dispatches
         Next (C);
      end loop;
   end Update;

end Dash_Board;
