with Interfaces.C.Strings; use Interfaces.C.Strings;
package Animals is
   --  -----------------------------------------------------------------------
   type Carnivore is interface;
   pragma Convention (C_Plus_Plus, Carnivore);
   function Number_Of_Teeth (X : Carnivore) return Natural is abstract;

   --  -----------------------------------------------------------------------
   type Domestic is interface;
   pragma Convention (C_Plus_Plus, Domestic);
   procedure Set_Owner (X : in out Domestic; Name : Chars_Ptr) is abstract;

   --  -----------------------------------------------------------------------
   type Animal is tagged record
      Age : Natural := 0;
   end record;
   pragma Import (C_Plus_Plus, Animal);

   procedure Set_Age (X : in out Animal; Age : Natural);
   pragma Import (C_Plus_Plus, Set_Age);

   function Age (X : Animal) return Natural;
   pragma Import (C_Plus_Plus, Age);

   --  -----------------------------------------------------------------------
   type Dog is new Animal and Carnivore and Domestic with record
      Tooth_Count : Natural;
      Owner       : String (1 .. 30);
   end record;
   pragma Import (C_Plus_Plus, Dog);

   function Number_Of_Teeth (A : Dog) return Natural;
   pragma Import (C_Plus_Plus, Number_Of_Teeth);

   procedure Set_Owner (A : in out Dog; Name : Chars_Ptr);
   pragma Import (C_Plus_Plus, Set_Owner);

   function New_Dog return Dog'Class;
   pragma CPP_Constructor (New_Dog);
   pragma Import (C_Plus_Plus, New_Dog, "_ZN3DogC2Ev");

   --  -----------------------------------------------------------------------
   --  Example of a type derivation defined in the Ada side that inherites
   --  all the dispatching primitives of the ancestor from the C++ side.

   type Vaccinated_Dog is new Dog with null record;
   function Vaccination_Expired (A : Vaccinated_Dog) return Boolean;
end Animals;
