------------------------------------------------------------------------------
--                                                                          --
--                  GNAT RUN-TIME LIBRARY (GNARL) COMPONENTS                --
--                                                                          --
--              S Y S T E M . B B . C P U _ P R I M I T I V E S .           --
--                       M U L T I P R O C E S S O R S                      --
--                                                                          --
--                                  S p e c                                 --
--                                                                          --
--                       Copyright (C) 2010, AdaCore                        --
--                                                                          --
-- GNARL is free software; you can  redistribute it  and/or modify it under --
-- terms of the  GNU General Public License as published  by the Free Soft- --
-- ware  Foundation;  either version 3,  or (at your option) any later ver- --
-- sion. GNARL is distributed in the hope that it will be useful, but WITH- --
-- OUT ANY WARRANTY;  without even the  implied warranty of MERCHANTABILITY --
-- or FITNESS FOR A PARTICULAR PURPOSE.                                     --
--                                                                          --
-- As a special exception under Section 7 of GPL version 3, you are granted --
-- additional permissions described in the GCC Runtime Library Exception,   --
-- version 3.1, as published by the Free Software Foundation.               --
--                                                                          --
-- In particular,  you can freely  distribute your programs  built with the --
-- GNAT Pro compiler, including any required library run-time units,  using --
-- any licensing terms  of your choosing.  See the AdaCore Software License --
-- for full details.                                                        --
--                                                                          --
------------------------------------------------------------------------------

pragma Restrictions (No_Elaboration_Code);

with System.Multiprocessors;

package System.BB.CPU_Primitives.Multiprocessors is
   pragma Preelaborate;

   function Current_CPU return System.Multiprocessors.CPU;
   pragma Inline (Current_CPU);
   --  Return the id of the current CPU

   procedure Poke_CPU (CPU_Id : System.Multiprocessors.CPU);
   --  Poke the given CPU to signal that a rescheduling may be required

   procedure Start_CPU (CPU_Id : System.Multiprocessors.CPU);
   --  Start given CPU

   procedure Start_All_CPUs;
   --  Start all CPUs

end System.BB.CPU_Primitives.Multiprocessors;
