----------------------------------
--
--  Copyright (C) 2012, AdaCore
--
----------------------------------

--  This is the main procedure for a utility program that displays the distance
--  travelled by an object on Earth in 10 seconds of free fall.

pragma Ada_2012;
with System.Dim.MKS;    use System.Dim.Mks;
with System.Dim.Mks_IO; use System.Dim.Mks_IO;
with Text_IO;           use Text_IO;

procedure Free_Fall is
   subtype Acceleration is Mks_Type
     with Dimension => ("m/sec^2", 1, 0, -2, others => 0);

   G : constant acceleration := 9.81 * m / (s ** 2);
   T : Time := 10.0*s;
   Distance : Length;

begin
   Put ("Gravitational constant: ");
   Put (G, Aft => 2, Exp => 0); Put_Line ("");

   Distance := 0.5 * G * T ** 2;

   Put ("distance travelled in 10 seconds of free fall ");
   Put (Distance, Aft => 2, Exp => 0);
   Put_Line ("");
end Free_Fall;
