/****************************************************************************
 *                                                                          *
 *                         GNAT COMPILER COMPONENTS                         *
 *                                                                          *
 *                                S Y S D E P                               *
 *                                                                          *
 *                          C Implementation File                           *
 *                                                                          *
 *         Copyright (C) 2009, Free Software Foundation, Inc.               *
 *                                                                          *
 * GNAT is free software;  you can  redistribute it  and/or modify it under *
 * terms of the  GNU General Public License as published  by the Free Soft- *
 * ware  Foundation;  either version 2,  or (at your option) any later ver- *
 * sion.  GNAT is distributed in the hope that it will be useful, but WITH- *
 * OUT ANY WARRANTY;  without even the  implied warranty of MERCHANTABILITY *
 * or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License *
 * for  more details.  You should have  received  a copy of the GNU General *
 * Public License  distributed with GNAT;  see file COPYING.  If not, write *
 * to  the  Free Software Foundation,  51  Franklin  Street,  Fifth  Floor, *
 * Boston, MA 02110-1301, USA.                                              *
 *                                                                          *
 * As a  special  exception,  if you  link  this file  with other  files to *
 * produce an executable,  this file does not by itself cause the resulting *
 * executable to be covered by the GNU General Public License. This except- *
 * ion does not  however invalidate  any other reasons  why the  executable *
 * file might be covered by the  GNU Public License.                        *
 *                                                                          *
 * GNAT was originally developed  by the GNAT team at  New York University. *
 * Extensive contributions were provided by Ada Core Technologies Inc.      *
 *                                                                          *
 ****************************************************************************/

/* This file contains system dependent symbols that are referenced in the
   GNAT Run Time Library - Version for Ravenscar cert VxWorks */

#include "vxWorks.h"
#include <taskLib.h>
#include <signal.h>

/* __gnat_get_task_options is used by s-taprop.adb only for VxWorks. This
   function returns the options to be set when creating a new task. It fetches
   the options assigned to the current task (parent), so offering some user
   level control over the options for a task hierarchy. It forces VX_FP_TASK
   because it is almost always required. */
extern int __gnat_get_task_options (void);

int
__gnat_get_task_options (void)
{
  int options;

#ifdef VTHREADS
  /* Get the options for the task creator */
  taskOptionsGet (taskIdSelf (), &options);

  /* Force VX_FP_TASK because it is almost always required */
  options |= VX_FP_TASK;
#else
  /* taskOptionsGet not available on VxWorks Cert 6 */
  options = VX_FP_TASK | VX_SUPERVISOR_MODE | VX_STDIO | VX_ADA_DEBUG;
#endif

  /* Mask those bits that are not under user control */
#ifdef VX_USR_TASK_OPTIONS
  return options & VX_USR_TASK_OPTIONS;
#else
  return options;
#endif
}
