------------------------------------------------------------------------------
--                                                                          --
--                         GNAT COMPILER COMPONENTS                         --
--                                                                          --
--                  GNAT.SOCKETS.THIN.SOCKET_ERROR_MESSAGE                  --
--                                                                          --
--                                 B o d y                                  --
--                                                                          --
--                     Copyright (C) 2007-2009, AdaCore                     --
--                                                                          --
-- GNAT is free software;  you can  redistribute it  and/or modify it under --
-- terms of the  GNU General Public License as published  by the Free Soft- --
-- ware  Foundation;  either version 2,  or (at your option) any later ver- --
-- sion.  GNAT is distributed in the hope that it will be useful, but WITH- --
-- OUT ANY WARRANTY;  without even the  implied warranty of MERCHANTABILITY --
-- or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License --
-- for  more details.  You should have  received  a copy of the GNU General --
-- Public License  distributed with GNAT;  see file COPYING.  If not, write --
-- to  the  Free Software Foundation,  51  Franklin  Street,  Fifth  Floor, --
-- Boston, MA 02110-1301, USA.                                              --
--                                                                          --
-- As a special exception,  if other files  instantiate  generics from this --
-- unit, or you link  this unit with other files  to produce an executable, --
-- this  unit  does not  by itself cause  the resulting  executable  to  be --
-- covered  by the  GNU  General  Public  License.  This exception does not --
-- however invalidate  any other reasons why  the executable file  might be --
-- covered by the  GNU Public License.                                      --
--                                                                          --
-- GNAT was originally developed  by the GNAT team at  New York University. --
-- Extensive contributions were provided by Ada Core Technologies Inc.      --
--                                                                          --
------------------------------------------------------------------------------

--  This is the default implementation of this unit, using the standard C
--  library's strerror(3) function. It is used on all platforms except Windows,
--  since on that platform socket errno values are distinct from the system
--  ones: there is a specific variant of this function in g-socthi-mingw.adb.

with System.CRTL.Runtime;

separate (GNAT.Sockets.Thin)

--------------------------
-- Socket_Error_Message --
--------------------------

function Socket_Error_Message
  (Errno : Integer) return C.Strings.chars_ptr
is
   use type Interfaces.C.Strings.chars_ptr;
   C_Msg : constant C.Strings.chars_ptr :=
             System.CRTL.Runtime.strerror (Errno);

begin
   if C_Msg = C.Strings.Null_Ptr then
      return Unknown_System_Error;
   else
      return C_Msg;
   end if;
end Socket_Error_Message;
