//////////////////////////////////////////////////////////////////////////////
//                                   AJIS                                   //
//                                                                          //
//                     Copyright (C) 2007-2012, AdaCore                     //
//                                                                          //
// This library is free software;  you can redistribute it and/or modify it //
// under terms of the  GNU General Public License  as published by the Free //
// Software  Foundation;  either version 3,  or (at your  option) any later //
// version. This library is distributed in the hope that it will be useful, //
// but WITHOUT ANY WARRANTY;  without even the implied warranty of MERCHAN- //
// TABILITY or FITNESS FOR A PARTICULAR PURPOSE.                            //
//                                                                          //
//                                                                          //
//                                                                          //
//                                                                          //
//                                                                          //
// You should have received a copy of the GNU General Public License and    //
// a copy of the GCC Runtime Library Exception along with this program;     //
// see the files COPYING3 and COPYING.RUNTIME respectively.  If not, see    //
// <http://www.gnu.org/licenses/>.                                          //
//                                                                          //
//////////////////////////////////////////////////////////////////////////////

package com.adacore.ajis.internal.ada;

import com.adacore.ajis.IEscapable;
import com.adacore.ajis.IProxy;
import com.adacore.ajis.NativeException;
import com.adacore.ajis.IProxy.Allocator;
import com.adacore.ajis.IProxy.Owner;

public final class Utils {

	public static void checkEscapable (IEscapable escapable, String objectName) {
		if (!escapable.isEscapable()) {
			String name;
			
			if (objectName != null) {
				name = "Value of " + objectName;
			} else {
				name = "Value";
			}

			if (escapable instanceof IProxy) {
				IProxy proxy = (IProxy) escapable;							
				
				if (proxy.getOwner() == Owner.PROXY) {
					throw new NativeException(name
							+ " cannot be escaped, "
							+ "because it's owned by the proxy. See pragma "
							+ "annotation \"Assume_Escaped\" for more details.");
				} else if (proxy.getAllocator() != Allocator.DYNAMIC) {
					throw new NativeException(name
							+ " cannot be escaped, "
							+ "because its allocator is not dynamic. See pragma "
							+ "annotation \"Assume_Escaped\" for more details.");
				}
			} else {
				throw new NativeException(name
						+ " cannot be escaped, see pragma "
						+ "annotation \"Assume_Escaped\" for more details.");
			}
		}
	}
	
}
