------------------------------------------------------------------------------
--                                                                          --
--                                 J N I                                    --
--                                                                          --
--                        Copyright (C) 2007, AdaCore                       --
--                                                                          --
-- This is free software;  you can  redistribute it  and/or modify it under --
-- terms of the  GNU General Public License as published  by the Free Soft- --
-- ware  Foundation;  either version 2,  or (at your option) any later ver- --
-- sion.  GNAT is distributed in the hope that it will be useful, but WITH- --
-- OUT ANY WARRANTY;  without even the  implied warranty of MERCHANTABILITY --
-- or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License --
-- for  more details.  You should have  received  a copy of the GNU General --
-- Public License  distributed with GNAT;  see file COPYING.  If not, write --
-- to  the  Free Software Foundation,  51  Franklin  Street,  Fifth  Floor, --
-- Boston, MA 02110-1301, USA.                                              --
--                                                                          --
------------------------------------------------------------------------------

with Ada.Text_IO; use Ada.Text_IO;

package body Test1 is

   ----------
   -- Test --
   ----------

   procedure Test is
   begin
      Put_Line ("Test1.Test");
   end Test;

   -----------
   -- Test2 --
   -----------

   procedure Test2 (I : Integer) is
   begin
      Put_Line ("Test1.Test2: got " & I'Img);
   end Test2;

   -----------
   -- Test3 --
   -----------

   procedure Test3 (I, J : Integer) is
   begin
      Put_Line ("Test1.Test3: got " & I'Img & " and " & J'Img);
   end Test3;

   -----------
   -- Test4 --
   -----------

   procedure Test4 (F : Float) is
   begin
      Put_Line ("Test1.Test4: " & Boolean'Image (F = 2.0/3.0));
   end Test4;

   -----------
   -- Test5 --
   -----------

   procedure Test5 (F : Long_Float) is
   begin
      Put_Line ("Test1.Test5: got " & F'Img);
   end Test5;

   -----------
   -- Test6 --
   -----------

   function Test6 return Integer is
   begin
      return 10;
   end Test6;

   -----------
   -- Test8 --
   -----------

   procedure Test8 (I : Integer) is
   begin
      Put_Line ("Test1.Test8: got " & I'Img);
   end Test8;

   -----------
   -- Test3 --
   -----------

   procedure Test8 (I, J : Integer) is
   begin
      Put_Line ("Test1.Test8: got " & I'Img & " and " & J'Img);
   end Test8;

end Test1;
