------------------------------------------------------------------------------
--                                 Ada2Java                                 --
--                                                                          --
--                     Copyright (C) 2007-2013, AdaCore                     --
--                                                                          --
-- This is free software;  you can redistribute it  and/or modify it  under --
-- terms of the  GNU General Public License as published  by the Free Soft- --
-- ware  Foundation;  either version 3,  or (at your option) any later ver- --
-- sion.  This software is distributed in the hope  that it will be useful, --
-- but WITHOUT ANY WARRANTY;  without even the implied warranty of MERCHAN- --
-- TABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public --
-- License for  more details.  You should have  received  a copy of the GNU --
-- General  Public  License  distributed  with  this  software;   see  file --
-- COPYING3.  If not, go to http://www.gnu.org/licenses for a complete copy --
-- of the license.                                                          --
------------------------------------------------------------------------------

--  This is a placeholder for the routine that performs all the tool-specific
--  initialization actions, that should be done before reading the tool
--  parameters. This placeholder does nothing

with Ada2Java;        use Ada2Java;
with Ada2Java.Kernel; use Ada2Java.Kernel;

with Ada2Java.Bound_Elements.Tagged_Types;
use Ada2Java.Bound_Elements.Tagged_Types;

with Ada2Java.Bound_Elements.Callbacks;
use Ada2Java.Bound_Elements.Callbacks;

separate (ASIS_UL.Environment)
procedure Tool_Specific_Initialization_1 is
begin
   The_Kernel := new Kernel_Record;

   Add_Bound_Element_Creator (The_Kernel, Create_Bound_Tagged_Type'Access);
   Add_Bound_Element_Creator (The_Kernel, Create_Bound_Callback'Access);
   Trace ("Initialization 1", Ada2Java.Debug);
end Tool_Specific_Initialization_1;
