------------------------------------------------------------------------------
--                                 Ada2Java                                 --
--                                                                          --
--                     Copyright (C) 2007-2013, AdaCore                     --
--                                                                          --
-- This is free software;  you can redistribute it  and/or modify it  under --
-- terms of the  GNU General Public License as published  by the Free Soft- --
-- ware  Foundation;  either version 3,  or (at your option) any later ver- --
-- sion.  This software is distributed in the hope  that it will be useful, --
-- but WITHOUT ANY WARRANTY;  without even the implied warranty of MERCHAN- --
-- TABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public --
-- License for  more details.  You should have  received  a copy of the GNU --
-- General  Public  License  distributed  with  this  software;   see  file --
-- COPYING3.  If not, go to http://www.gnu.org/licenses for a complete copy --
-- of the license.                                                          --
------------------------------------------------------------------------------

with Ada.Text_IO;                use Ada.Text_IO;

package Ada2Java.Config is

   type Configuration is private;

   Null_Configuration : constant Configuration;

   procedure Set_Java_Base_Package
     (Conf : in out Configuration; Base_Package : Wide_String);
   --  Set the value of the java base package

   procedure Set_Ada_Output_Directory
     (Conf : in out Configuration; Output_Directory : Wide_String);
   --  Set the value of the ada directory where the binding has to be stored

   procedure Set_Java_Class_Path
     (Conf : in out Configuration; Class_Path : Wide_String);
   --  Set the value of the resulting class path

   function Get_Java_Base_Package
     (Conf : Configuration) return Wide_String;
   --  Retreive the value of the java base package

   function Get_Ada_Output_Directory
     (Conf : Configuration) return Wide_String;
   --  Return the value of the directory where ada resulting files are stored

   function Get_Java_Class_Path
     (Conf : Configuration) return Wide_String;
   --  Return the value of the resulting Java class path.

   procedure Parse_File (File : File_Type; Conf : in out Configuration);
   --  Parse the configuration file given in parameter. Only specified values
   --  are overwritten in the configuration, previous ones are let as is.

private

   type Configuration is record
      Java_Base_Package    : Unbounded_Wide_String;
      Java_Class_Path      : Unbounded_Wide_String;
      Ada_Output_Directory : Unbounded_Wide_String;
   end record;

   Null_Configuration : constant Configuration := (others => <>);

end Ada2Java.Config;
