------------------------------------------------------------------------------
--                                 Ada2Java                                 --
--                                                                          --
--                     Copyright (C) 2008-2013, AdaCore                     --
--                                                                          --
-- This is free software;  you can redistribute it  and/or modify it  under --
-- terms of the  GNU General Public License as published  by the Free Soft- --
-- ware  Foundation;  either version 3,  or (at your option) any later ver- --
-- sion.  This software is distributed in the hope  that it will be useful, --
-- but WITHOUT ANY WARRANTY;  without even the implied warranty of MERCHAN- --
-- TABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public --
-- License for  more details.  You should have  received  a copy of the GNU --
-- General  Public  License  distributed  with  this  software;   see  file --
-- COPYING3.  If not, go to http://www.gnu.org/licenses for a complete copy --
-- of the license.                                                          --
------------------------------------------------------------------------------

--  This package provides access to common simple elements.

package Ada2Java.Bound_Elements.Common is

   function Get_Exception_Occurence
     (Handle : not null access Ada2Java.Kernel.Kernel_Record)
      return Simple_Type_View_Access;
   --  Returns a handle on the predefined Ada.Exception.Exception_Occurence
   --  type.

   function Get_String
     (Handle : not null access Ada2Java.Kernel.Kernel_Record)
      return Simple_Type_Reference;
   --  Returns a handle on the predefined Standard.String type.

   function Get_Boolean
     (Handle : not null access Ada2Java.Kernel.Kernel_Record)
      return Simple_Type_View_Access;
   --  Returns a handle on the predefined Standard.Boolean type.

   function Get_Standard_Package
     (Handle : not null access Ada2Java.Kernel.Kernel_Record)
      return Ada2Java.Packages.Package_Handle;
   --  Returns a handle on the predefined Standard package.

end Ada2Java.Bound_Elements.Common;
