//////////////////////////////////////////////////////////////////////////////
//                                   AJIS                                   //
//                                                                          //
//                     Copyright (C) 2007-2012, AdaCore                     //
//                                                                          //
// This library is free software;  you can redistribute it and/or modify it //
// under terms of the  GNU General Public License  as published by the Free //
// Software  Foundation;  either version 3,  or (at your  option) any later //
// version. This library is distributed in the hope that it will be useful, //
// but WITHOUT ANY WARRANTY;  without even the implied warranty of MERCHAN- //
// TABILITY or FITNESS FOR A PARTICULAR PURPOSE.                            //
//                                                                          //
//                                                                          //
//                                                                          //
//                                                                          //
//                                                                          //
// You should have received a copy of the GNU General Public License and    //
// a copy of the GCC Runtime Library Exception along with this program;     //
// see the files COPYING3 and COPYING.RUNTIME respectively.  If not, see    //
// <http://www.gnu.org/licenses/>.                                          //
//                                                                          //
//////////////////////////////////////////////////////////////////////////////

package com.adacore.ajis.internal.ada;

import com.adacore.ajis.IProxy;
import com.adacore.ajis.IProxyRef;
import com.adacore.ajis.NativeException;

public abstract class AdaProxy implements IProxy {

	/**
	 * When this is not null, this points to the proxy object containing this
	 * proxy, so that it's not garbage-collected until this object is subject
	 * to garbage collection as well.
	 */
	public IProxy container;
	
	public Owner myOwner = Owner.NATIVE;
	
	public Allocator myAllocator = Allocator.UNKNOWN;
	
	protected int [] adaAccess;
	
	public int [] getAccess () {
		return adaAccess;
	}
		
	public IProxyRef NewProxyRef () {
		return null;
	}
	
	public AdaProxy (){

	}

	public AdaProxy (AdaAccess access) {
		if (access != null) this.adaAccess = access.fAcc;
	}
	
	public Object clone () throws CloneNotSupportedException {
		AdaProxy cloned = (AdaProxy) super.clone ();
		
		cloned.adaAccess = internalClone ();
		cloned.proxyCloned(this);
		
		return cloned;
	}

	public void setOwner (Owner theOwner) {
		if (getOwner() == theOwner) {
			//  Nothing has to change
		} else if (getAllocator() == Allocator.DYNAMIC) {
			myOwner = theOwner;
		} else {
			throw new NativeException(
					"Only objects allocated dynamically can change owner.");
		}
	}

	public Owner getOwner () {
		return myOwner;
	}
	
	public Allocator getAllocator () {
		return myAllocator;
	}

	public void proxyCloned (IProxy initialObject) {
	
	}
	
	protected void finalize () {
		if (myOwner == Owner.PROXY 
				&& adaAccess != null 
				&& myAllocator == Allocator.DYNAMIC) {
			deallocateNativeObject();
		}
	}

	@SuppressWarnings("unused")
	private void setAddress (int [] address) {
		this.adaAccess = address;
	}
	
	@SuppressWarnings("unused")
	private AdaProxy cloneNoCopy () throws CloneNotSupportedException {
		AdaProxy cloned = (AdaProxy) super.clone ();
		
		return cloned;
	}
	
	public boolean isEscapable () {
		return myOwner == Owner.NATIVE 
		&& myAllocator == Allocator.DYNAMIC;
	}
	
	protected abstract int [] internalClone ();
}
