//////////////////////////////////////////////////////////////////////////////
//                                  AJIS                                    //
//                                                                          //
//                     Copyright (C) 2008-2012, AdaCore                     //
//                                                                          //
// This library is free software;  you can redistribute it and/or modify it //
// under terms of the  GNU General Public License  as published by the Free //
// Software  Foundation;  either version 3,  or (at your  option) any later //
// version. This library is distributed in the hope that it will be useful, //
// but WITHOUT ANY WARRANTY;  without even the implied warranty of MERCHAN- //
// TABILITY or FITNESS FOR A PARTICULAR PURPOSE.                            //
//                                                                          //
//                                                                          //
//                                                                          //
//                                                                          //
//                                                                          //
// You should have received a copy of the GNU General Public License and    //
// a copy of the GCC Runtime Library Exception along with this program;     //
// see the files COPYING3 and COPYING.RUNTIME respectively.  If not, see    //
// <http://www.gnu.org/licenses/>.                                          //
//                                                                          //
//////////////////////////////////////////////////////////////////////////////

package com.adacore.ajis;

public class AJISLibrary {	

	public static class LibraryError extends Exception {
		
		/**
		 *
		 */
		private static final long serialVersionUID = 7061773557446376442L;

		public LibraryError (String message) {
			super (message);
		}
		
	}
	
	private static boolean fLoaded = false;

	/**
	 * Loads the predefined libraries used for AJIS. Calling this multiple
	 * times has no effect.
	 */
	public static void load () {
		if (!fLoaded) {
			fLoaded = true;
			
			System.loadLibrary ("gnatjni");
			System.loadLibrary ("ajis");
		}
	}
		
	/**
	 * Preempts the automatic load of the library. This function has to be
	 * called before any attempt on load is made. The caller in then
	 * responsible to load AJIS native libraries.
	 *
	 * This subprogram should not be used except on specific situation
	 * involving to shortcut the standard load of native libraries.
	 *
	 * @throws LibraryError thrown if the library has already been loaded, or
	 * if somebody else has already preempted the load.
	 */
	public static void preemptLoad () throws LibraryError {
		if (fLoaded) {
			throw new LibraryError
			("The native environment is already loaded");
		} else {
			fLoaded = true;
		}
	}
}
