#!/bin/bash
export C_INCLUDE_PATH="$JAVA_SDK/include;$JAVA_SDK/include/win32;$C_INCLUDE_PATH"
export CLASSPATH="`pwd`/../runtime/java;$CLASSPATH"
export PATH=$JAVA_SDK/bin:$PATH

function do_test_dump ()
{
   test=$1

   cd $test
   echo "TESTING: $test"
   sh test.cmd | tr -d '\r' > test.out.new 2>&1
   diff -u test.out test.out.new
   cd ..
}

function do_test_exec ()
{(
   test=$1
   echo "TESTING: $test"
   cd $test

   export CLASSPATH="`pwd`;`pwd`/java;$CLASSPATH"
   export PATH="`pwd`/ada/lib/:$PATH"
   export LD_LIBRARY_PATH="`pwd`/ada/lib/:$LD_LIBRARY_PATH"
   rm -f obj/*.ali
   rm -f obj/*.o
   rm -f lib/*
   rm -rf ada/ java/

   PWD=`pwd`
   num_test=`basename $PWD | cut -d'.' -f2-`

   (
     if [ -f test.cmd ]; then
        sh test.cmd
     else
        if [ -f bind.cmd ]; then
           sh bind.cmd
        else
           ada2java test.ads \
            -b com.adacore.test$num_test \
            -c `pwd`/java/ \
            -o `pwd`/ada/ \
            -L test \
            --no-assume-escaped \
            --attach-parameter \
            -P bind.gpr
        fi

        gprbuild -q -p -Pada/test.gpr

        if [ -f test$num_test.java ]; then
           javac test$num_test.java
           java test$num_test
        fi
     fi
   ) | tr -d '\r' > test.out.new 2>&1


   diff -u test.out test.out.new
   cd ..
)}

if [ "$1" = "" ]; then
   for j in exec.*; do
      do_test_exec $j
   done
else
   case $1 in
      exec.*)
         do_test_exec $1
         ;;
      clean)
        for j in exec.*; do
           echo "CLEANING $j"
           cd $j
           rm -rf ada/ java/
           rm -f test.out.new *.class
           rm -rf GNAT-*
           cd ..
        done
   esac
fi
