------------------------------------------------------------------------------
--                                 Ada2Java                                 --
--                                                                          --
--                     Copyright (C) 2008-2013, AdaCore                     --
--                                                                          --
-- This is free software;  you can redistribute it  and/or modify it  under --
-- terms of the  GNU General Public License as published  by the Free Soft- --
-- ware  Foundation;  either version 3,  or (at your option) any later ver- --
-- sion.  This software is distributed in the hope  that it will be useful, --
-- but WITHOUT ANY WARRANTY;  without even the implied warranty of MERCHAN- --
-- TABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public --
-- License for  more details.  You should have  received  a copy of the GNU --
-- General  Public  License  distributed  with  this  software;   see  file --
-- COPYING3.  If not, go to http://www.gnu.org/licenses for a complete copy --
-- of the license.                                                          --
------------------------------------------------------------------------------

with Ada.Containers.Indefinite_Doubly_Linked_Lists;
with Ada.Containers.Indefinite_Ordered_Maps;

with Ada2Java.Dynamic_Expressions; use Ada2Java.Dynamic_Expressions;

package Ada2Java.Code_Templates is

   type Code_Template is private;

   package Template_Parameter_Association is new
     Ada.Containers.Indefinite_Ordered_Maps (Wide_String, Dynamic_Expression);

   function Load_Template_From_Path (File_Path : String) return Code_Template;
   --  Loads a template from a full path.

   function Load_Template (Name : String) return Code_Template;
   --  Loads the template of the given name, as saved in the expected location
   --  <ajis_install>/share/ajis/templates/<name>.tpl

   function Instantiate
     (Template   : Code_Template;
      Parameters : Template_Parameter_Association.Map)
      return Dynamic_Expression;
   --  Generates a dynamic expression according to the template with parameters
   --  instantiated with the map given.

private

   type Section_Kind is (Raw_Text, Parameter);

   type Section_Record (Length : Integer) is record
      Contents : String (1 .. Length);
      Kind     : Section_Kind;
   end record;

   package Section_List is new
     Ada.Containers.Indefinite_Doubly_Linked_Lists (Section_Record);

   type Template_Record is record
      Sections : Section_List.List;
   end record;

   type Code_Template is access all Template_Record;

end Ada2Java.Code_Templates;
