//////////////////////////////////////////////////////////////////////////////
//                                  AJIS                                    //
//                                                                          //
//                     Copyright (C) 2007-2012, AdaCore                     //
//                                                                          //
// This library is free software;  you can redistribute it and/or modify it //
// under terms of the  GNU General Public License  as published by the Free //
// Software  Foundation;  either version 3,  or (at your  option) any later //
// version. This library is distributed in the hope that it will be useful, //
// but WITHOUT ANY WARRANTY;  without even the implied warranty of MERCHAN- //
// TABILITY or FITNESS FOR A PARTICULAR PURPOSE.                            //
//                                                                          //
//                                                                          //
//                                                                          //
//                                                                          //
//                                                                          //
// You should have received a copy of the GNU General Public License and    //
// a copy of the GCC Runtime Library Exception along with this program;     //
// see the files COPYING3 and COPYING.RUNTIME respectively.  If not, see    //
// <http://www.gnu.org/licenses/>.                                          //
//                                                                          //
//////////////////////////////////////////////////////////////////////////////

package com.adacore.ajis;

public interface IProxy extends Cloneable, IEscapable {

	public enum Owner {PROXY, NATIVE};
	
	public enum Allocator {STATIC, DYNAMIC, UNKNOWN}
	
	/**
	 * Create a new object indirect reference to the proxy.
	 */
	public IProxyRef NewProxyRef ();
	
	/**
	 * Set whether the native object is owned by the proxy, and thus needs to
	 * be freed on finalize. Objects allocated statically cannot change their
	 * owner.
	 */
	public void setOwner (Owner theOwner);

	/**
	 * return whether the owner of the native object
	 */
	public Owner getOwner ();
	
	/**
	 * Return the kind of allocator used to produce the native data of this
	 * proxy.
	 */
	public Allocator getAllocator ();
	
	/**
	 * This function is called whenever the proxy is copied. Clone is only
	 * 	called when the object is copied from Java, not from Ada. The native
	 *  object may not have been already linked to the proxy, so calls to
	 *  bound primitives should be avoided at this stage.
	 */
	public void proxyCloned (IProxy initialObject);
	
	/**
	 * Force the deallocation of the native object. This does not take into
	 * account the owning attribute of the string. The user must ensure that
	 * the object have been created on the heap, otherwise memory corruptions
	 * will occure. Using the standard owning mechanism should be prefered than
	 * directly calling deallocation whenever possible.
	 */
	public void deallocateNativeObject ();
}
