--::::::::::
--room.ads
--::::::::::
with Chop;
with Phil;
with Society;
with AJIS.Annotations; use AJIS.Annotations;

package Room is

   -- Dining Philosophers - Ada 95 edition

   -- Room.Maitre_D is responsible for assigning seats at the
   --   table, "left" and "right" chopsticks, and for reporting
   --   interesting events to the outside world.

   -- Michael B. Feldman, The George Washington University,
   -- July, 1995.

   type State_Reporter is abstract tagged null record;

   type State_Reporter_Access is access all State_Reporter'Class;

   procedure Report
     (This        : State_Reporter;
      Phil_Number : Society.Unique_DNA_Codes;
      Clock       : Natural;
      State       : Phil.States;
      How_Long    : in Natural;
      Which_Meal  : in Natural) is abstract;

   Reporter : State_Reporter_Access;

   Table_Size : constant := 5;
   subtype Table_Type is Positive range 1 .. Table_Size;

   Sticks : array (Table_Type) of Chop.Stick;

   procedure Start_Serving;
   --  This subprogram is a wrapper to Maitre_D.Start_Serving, since entries
   --  are not bound so far in AJIS

   task Maitre_D is
      entry Start_Serving;
      entry Report_State (Which_Phil : in Society.Unique_DNA_Codes;
                          State      : in Phil.States;
                          How_Long   : in Natural := 0;
                          Which_Meal : in Natural := 0);
   end Maitre_D;



end Room;
