//////////////////////////////////////////////////////////////////////////////
//                                                                          //
//                                  AJIS                                    //
//                                                                          //
//                        Copyright (C) 2008, AdaCore                       //
//                                                                          //
// GNAT is free software;  you can  redistribute it  and/or modify it under //
// terms of the  GNU General Public License as published  by the Free Soft- //
// ware  Foundation;  either version 2,  or (at your option) any later ver- //
// sion.  GNAT is distributed in the hope that it will be useful, but WITH- //
// OUT ANY WARRANTY;  without even the  implied warranty of MERCHANTABILITY //
// or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License //
// for  more details.  You should have  received  a copy of the GNU General //
// Public License  distributed with GNAT;  see file COPYING.  If not, write //
// to  the  Free Software Foundation,  51  Franklin  Street,  Fifth  Floor, //
// Boston, MA 02110-1301, USA.                                              //
//                                                                          //
//                                                                          //
//                                                                          //
//                                                                          //
//                                                                          //
//                                                                          //
//                                                                          //
//                                                                          //
//////////////////////////////////////////////////////////////////////////////

package com.adacore.ajis;

public class AJISLibrary {	

	public static class LibraryError extends Exception {
		
		/**
		 *
		 */
		private static final long serialVersionUID = 7061773557446376442L;

		public LibraryError (String message) {
			super (message);
		}
		
	}
	
	private static boolean fLoaded = false;

	/**
	 * Loads the predefined libraries used for AJIS. Calling this multiple
	 * times has no effect.
	 */
	public static void load () {
		if (!fLoaded) {
			fLoaded = true;
			
			System.loadLibrary ("gnatjni");
			System.loadLibrary ("ajis");
		}
	}
		
	/**
	 * Preempts the automatic load of the library. This function has to be
	 * called before any attempt on load is made. The caller in then
	 * responsible to load AJIS native libraries.
	 *
	 * This subprogram should not be used except on specific situation
	 * involving to shortcut the standard load of native libraries.
	 *
	 * @throws LibraryError thrown if the library has already been loaded, or
	 * if somebody else has already preempted the load.
	 */
	public static void preemptLoad () throws LibraryError {
		if (fLoaded) {
			throw new LibraryError
			("The native environment is already loaded");
		} else {
			fLoaded = true;
		}
	}
}
