package com.adacore.ajis.examples.philosophers;

import com.adacore.ajis.examples.philosophers.Phil.States;
import com.adacore.ajis.examples.philosophers.Room.State_Reporter;
import com.adacore.ajis.examples.philosophers.Phil.States;

public class JavaStateReporter extends State_Reporter {

	private PhilosopherPanel [] pannels;
	
	public JavaStateReporter (PhilosopherPanel [] pannels) {
		this.pannels = pannels;
	}
	
	@Override
	public void Report(int Phil_Number, int Clock, com.adacore.ajis.examples.philosophers.Phil.States State, int How_Long,
			int Which_Meal) {

		String message = "[" + Clock + "] ";
		
		switch (State) {
		case Breathing:
			message += "Breathing...";
			break;
		case Thinking:
			message += "Thinking " + How_Long + " seconds";
			break;
		case Eating:
			message += "Meal " + Which_Meal;
			break;
		case Done_Eating:
			message += "Yum-yum (burps)";
			break;
		case Got_One_Stick:
			message += "First chopstick " + How_Long;
			break;
		case Got_Other_Stick:
			message += "Second chopstick " + How_Long;
			break;
		case Dying:
			message += "Croak";
			break;
		}

		pannels [Phil_Number - 1].registerEvent(message);

	}

}
