------------------------------------------------------------------------------
--                                                                          --
--                         GNAT RUN-TIME COMPONENTS                         --
--                                                                          --
--                 A D A . E X C E P T I O N S . D O T N E T                --
--                                                                          --
--                                 B o d y                                  --
--                                                                          --
--                       Copyright (C) 2009, AdaCore                        --
--                                                                          --
-- GNAT is free software;  you can  redistribute it  and/or modify it under --
-- terms of the  GNU General Public License as published  by the Free Soft- --
-- ware  Foundation;  either version 2,  or (at your option) any later ver- --
-- sion.  GNAT is distributed in the hope that it will be useful, but WITH- --
-- OUT ANY WARRANTY;  without even the  implied warranty of MERCHANTABILITY --
-- or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License --
-- for  more details.  You should have  received  a copy of the GNU General --
-- Public License  distributed with GNAT;  see file COPYING.  If not, write --
-- to  the Free Software Foundation,  59 Temple Place - Suite 330,  Boston, --
-- MA 02111-1307, USA.                                                      --
--                                                                          --
--                                                                          --
--                                                                          --
--                                                                          --
--                                                                          --
--                                                                          --
--                                                                          --
--                                                                          --
--                                                                          --
-- The GNAT Ada tool chain for the JVM and .NET platforms is  maintained by --
-- AdaCore - http://www.adacore.com                                         --
--                                                                          --
------------------------------------------------------------------------------

with System.Soft_Links; use System.Soft_Links;
with Ada.Exceptions;    use Ada.Exceptions;

package body Ada.Exceptions.Dotnet is

   --  Gnat_Raise_With_Msg and Gnat_Reraise are marked unreferenced as they
   --  are used only indirectly via the run-time calls to
   --  pragma Import (C, __gnat_reraise*) that are redirected here by the
   --  .NET backend

   procedure Gnat_Raise_With_Msg (X : Ada.Exceptions.Exception_Id);
   pragma Unreferenced (Gnat_Raise_With_Msg);
   --  Raise exception X with message of the current exception
   --  equivalent to __gnat_raise_with_msg C function.

   procedure Gnat_Reraise;
   pragma Unreferenced (Gnat_Reraise);
   --  Reraise the current exception
   --  equivalent to __gnat_reraise C function.

   function Create_EO
     (E : Exception_Id; M : String)
      return Exception_Occurrence;
   pragma Import (CIL, Create_EO, "mgnat.adalib.GNAT_libc.create_EO");
   --  Creates an EO corresponding to E containing Message

   -------------------------
   -- Gnat_Raise_With_Msg --
   -------------------------

   procedure Gnat_Raise_With_Msg (X : Ada.Exceptions.Exception_Id) is
      E : constant Ada.Exceptions.Exception_Occurrence_Access :=
            Get_Current_Excep.all;

   begin
      if E.all = Ada.Exceptions.Null_Occurrence then
         Ada.Exceptions.Reraise_Occurrence (Create_EO (X, ""));
      else
         Ada.Exceptions.Reraise_Occurrence
           (Create_EO (X, Ada.Exceptions.Exception_Message (E.all)));
      end if;
   end Gnat_Raise_With_Msg;

   ------------------
   -- Gnat_Reraise --
   ------------------

   procedure Gnat_Reraise is
      E : constant Ada.Exceptions.Exception_Occurrence :=
            Get_Current_Excep.all.all;
   begin
      Ada.Exceptions.Reraise_Occurrence (E);
   end Gnat_Reraise;

end Ada.Exceptions.Dotnet;
