------------------------------------------------------------------------------
--                                   JNI                                    --
--                                                                          --
--                     Copyright (C) 2005-2007, AdaCore                     --
--                                                                          --
-- GNAT is free software;  you can  redistribute it  and/or modify it under --
-- terms of the  GNU General Public License as published  by the Free Soft- --
-- ware  Foundation;  either version 2,  or (at your option) any later ver- --
-- sion.  GNAT is distributed in the hope that it will be useful, but WITH- --
-- OUT ANY WARRANTY;  without even the  implied warranty of MERCHANTABILITY --
-- or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License --
-- for  more details.  You should have  received  a copy of the GNU General --
-- Public License  distributed with GNAT;  see file COPYING.  If not, write --
-- to  the  Free Software Foundation,  51  Franklin  Street,  Fifth  Floor, --
-- Boston, MA 02110-1301, USA.                                              --
------------------------------------------------------------------------------

with JNI; use JNI;

package Java_Primitives is

   ---------------------
   -- Primitive types --
   ---------------------

   subtype Boolean       is J_Boolean;
   subtype Boolean_Array is J_Boolean_Array;
   subtype Char          is J_Char;
   subtype Char_Array    is J_Char_Array;
   subtype Byte          is J_Byte;
   subtype Byte_Array    is J_Byte_Array;
   subtype Short         is J_Short;
   subtype Short_Array   is J_Short_Array;
   subtype Int           is J_Int;
   subtype Int_Array     is J_Int_Array;
   subtype Long          is J_Long;
   subtype Long_Array    is J_Long_Array;
   subtype Float         is J_Float;
   subtype Float_Array   is J_Float_Array;
   subtype Double        is J_Double;
   subtype Double_Array  is J_Double_Array;

end Java_Primitives;
