------------------------------------------------------------------------------
--                                   JNI                                    --
--                                                                          --
--                     Copyright (C) 2005-2007, AdaCore                     --
--                                                                          --
-- GNAT is free software;  you can  redistribute it  and/or modify it under --
-- terms of the  GNU General Public License as published  by the Free Soft- --
-- ware  Foundation;  either version 2,  or (at your option) any later ver- --
-- sion.  GNAT is distributed in the hope that it will be useful, but WITH- --
-- OUT ANY WARRANTY;  without even the  implied warranty of MERCHANTABILITY --
-- or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License --
-- for  more details.  You should have  received  a copy of the GNU General --
-- Public License  distributed with GNAT;  see file COPYING.  If not, write --
-- to  the  Free Software Foundation,  51  Franklin  Street,  Fifth  Floor, --
-- Boston, MA 02110-1301, USA.                                              --
------------------------------------------------------------------------------

with Java_Primitives;  use Java_Primitives;

with Java.Lang.Object;
with JNI_Object;       use JNI_Object;

package Java_Arrays is

   ----------------------------------
   -- Primitive Boolean Array Type --
   ----------------------------------

   type Boolean_Typ_Arr is abstract new Java.Lang.Object.Root_Array
     with private;
   type Boolean_Arr is access all Boolean_Typ_Arr'Class;

   function New_Boolean_Arr (Length : Int) return Boolean_Arr;

   function New_Boolean_Arr (Arr : Boolean_Array) return Boolean_Arr;

   function Get_Boolean
     (Arr : access Boolean_Typ_Arr;
      Pos : Int)
      return Java_Primitives.Boolean;

   procedure Set_Boolean
     (Arr   : access Boolean_Typ_Arr;
      Pos   : Int;
      Value : Java_Primitives.Boolean);

   type Boolean_Typ_Arr_2 is abstract new Java.Lang.Object.Root_Array
     with private;
   type Boolean_Arr_2 is access all Boolean_Typ_Arr_2'Class;

   -------------------------------
   -- Primitive Char Array Type --
   -------------------------------

   type Char_Typ_Arr is abstract new Java.Lang.Object.Root_Array with private;
   type Char_Arr is access all Char_Typ_Arr'Class;

   function New_Char_Arr (Length : Int) return Char_Arr;

   function New_Char_Arr (Arr : Char_Array) return Char_Arr;

   function Get_Char
     (Arr : access Char_Typ_Arr;
      Pos : Int) return Char;

   procedure Set_Char
     (Arr   : access Char_Typ_Arr;
      Pos   : Int;
      Value : Char);

   type Char_Typ_Arr_2 is abstract new Java.Lang.Object.Root_Array
     with private;
   type Char_Arr_2 is access all Char_Typ_Arr_2'Class;

   -------------------------------
   -- Primitive Byte Array Type --
   -------------------------------

   type Byte_Typ_Arr is abstract new Java.Lang.Object.Root_Array with private;
   type Byte_Arr is access all Byte_Typ_Arr'Class;

   function New_Byte_Arr (Length : Int) return Byte_Arr;

   function New_Byte_Arr (Arr : Byte_Array) return Byte_Arr;

   function Get_Byte
     (Arr : access Byte_Typ_Arr;
      Pos : Int)
      return Java_Primitives.Byte;

   procedure Set_Byte
     (Arr   : access Byte_Typ_Arr;
      Pos   : Int;
      Value : Java_Primitives.Byte);

   type Byte_Typ_Arr_2 is abstract new Java.Lang.Object.Root_Array
     with private;
   type Byte_Arr_2 is access all Byte_Typ_Arr_2'Class;

   --------------------------------
   -- Primitive Short Array Type --
   --------------------------------

   type Short_Typ_Arr is abstract new Java.Lang.Object.Root_Array with private;
   type Short_Arr is access all Short_Typ_Arr'Class;

   function New_Short_Arr (Length : Int) return Short_Arr;

   function New_Short_Arr (Arr : Short_Array) return Short_Arr;

   function Get_Short
     (Arr : access Short_Typ_Arr;
      Pos : Int)
      return Java_Primitives.Short;

   procedure Set_Short
     (Arr   : access Short_Typ_Arr;
      Pos   : Int;
      Value : Java_Primitives.Short);

   type Short_Typ_Arr_2 is abstract new Java.Lang.Object.Root_Array
     with private;
   type Short_Arr_2 is access all Short_Typ_Arr_2'Class;

   ------------------------------
   -- Primitive Int Array Type --
   ------------------------------

   type Int_Typ_Arr is abstract new Java.Lang.Object.Root_Array with private;
   type Int_Arr is access all Int_Typ_Arr'Class;

   function New_Int_Arr (Length : Int) return Int_Arr;

   function New_Int_Arr (Arr : Int_Array) return Int_Arr;

   function Get_Int
     (Arr : access Int_Typ_Arr;
      Pos : Int)
      return Java_Primitives.Int;

   procedure Set_Int
     (Arr   : access Int_Typ_Arr;
      Pos   : Int;
      Value : Java_Primitives.Int);

   type Int_Typ_Arr_2 is abstract new Java.Lang.Object.Root_Array with private;
   type Int_Arr_2 is access all Int_Typ_Arr_2'Class;

   -------------------------------
   -- Primitive Long Array Type --
   -------------------------------

   type Long_Typ_Arr is abstract new Java.Lang.Object.Root_Array with private;
   type Long_Arr is access all Long_Typ_Arr'Class;

   function New_Long_Arr (Length : Int) return Long_Arr;

   function New_Long_Arr (Arr : Long_Array) return Long_Arr;

   function Get_Long
     (Arr : access Long_Typ_Arr;
      Pos : Int)
      return Java_Primitives.Long;

   procedure Set_Long
     (Arr   : access Long_Typ_Arr;
      Pos   : Int;
      Value : Java_Primitives.Long);

   type Long_Typ_Arr_2 is abstract new Java.Lang.Object.Root_Array
     with private;
   type Long_Arr_2 is access all Long_Typ_Arr_2'Class;

   --------------------------------
   -- Primitive Float Array Type --
   --------------------------------

   type Float_Typ_Arr is abstract new Java.Lang.Object.Root_Array with private;
   type Float_Arr is access all Float_Typ_Arr'Class;

   function New_Float_Arr (Length : Int) return Float_Arr;

   function New_Float_Arr (Arr : Float_Array) return Float_Arr;

   function Get_Float
     (Arr : access Float_Typ_Arr;
      Pos : Int)
      return Java_Primitives.Float;

   procedure Set_Float
     (Arr   : access Float_Typ_Arr;
      Pos   : Int;
      Value : Java_Primitives.Float);

   type Float_Typ_Arr_2 is abstract new Java.Lang.Object.Root_Array
     with private;
   type Float_Arr_2 is access all Float_Typ_Arr_2'Class;

   ---------------------------------
   -- Primitive Double Array Type --
   ---------------------------------

   type Double_Typ_Arr is abstract new Java.Lang.Object.Root_Array
     with private;
   type Double_Arr is access all Double_Typ_Arr'Class;

   function New_Double_Arr (Length : Int) return Double_Arr;

   function New_Double_Arr (Arr : Double_Array) return Double_Arr;

   function Get_Double
     (Arr : access Double_Typ_Arr;
      Pos : Int)
      return Java_Primitives.Double;

   procedure Set_Double
     (Arr   : access Double_Typ_Arr;
      Pos   : Int;
      Value : Java_Primitives.Double);

   type Double_Typ_Arr_2 is abstract new Java.Lang.Object.Root_Array
     with private;
   type Double_Arr_2 is access all Double_Typ_Arr_2'Class;

private
   type Boolean_Typ_Arr is new Java.Lang.Object.Root_Array
     with null record;

   function JNI_Constructor
     (Params : not null access Parameters) return Boolean_Typ_Arr;

   type Char_Typ_Arr is new Java.Lang.Object.Root_Array
     with null record;

   function JNI_Constructor
     (Params : not null access Parameters) return Char_Typ_Arr;

   type Byte_Typ_Arr is new Java.Lang.Object.Root_Array
     with null record;

   function JNI_Constructor
     (Params : not null access Parameters) return Byte_Typ_Arr;

   type Short_Typ_Arr is new Java.Lang.Object.Root_Array
     with null record;

   function JNI_Constructor
     (Params : not null access Parameters) return Short_Typ_Arr;

   type Int_Typ_Arr is new Java.Lang.Object.Root_Array
     with null record;

   function JNI_Constructor
     (Params : not null access Parameters) return Int_Typ_Arr;

   type Long_Typ_Arr is new Java.Lang.Object.Root_Array
     with null record;

   function JNI_Constructor
     (Params : not null access Parameters) return Long_Typ_Arr;

   type Float_Typ_Arr is new Java.Lang.Object.Root_Array
     with null record;

   function JNI_Constructor
     (Params : not null access Parameters) return Float_Typ_Arr;

   type Double_Typ_Arr is new Java.Lang.Object.Root_Array
     with null record;

   function JNI_Constructor
     (Params : not null access Parameters) return Double_Typ_Arr;

   type Boolean_Typ_Arr_2 is new Java.Lang.Object.Root_Array
     with null record;

   function JNI_Constructor (Params : not null access Parameters)
     return Boolean_Typ_Arr_2;

   type Char_Typ_Arr_2 is new Java.Lang.Object.Root_Array
     with null record;

   function JNI_Constructor
     (Params : not null access Parameters) return Char_Typ_Arr_2;

   type Byte_Typ_Arr_2 is new Java.Lang.Object.Root_Array
     with null record;

   function JNI_Constructor
     (Params : not null access Parameters) return Byte_Typ_Arr_2;

   type Short_Typ_Arr_2 is new Java.Lang.Object.Root_Array
     with null record;

   function JNI_Constructor
     (Params : not null access Parameters) return Short_Typ_Arr_2;

   type Int_Typ_Arr_2 is new Java.Lang.Object.Root_Array
     with null record;

   function JNI_Constructor
     (Params : not null access Parameters) return Int_Typ_Arr_2;

   type Long_Typ_Arr_2 is new Java.Lang.Object.Root_Array
     with null record;

   function JNI_Constructor (Params : not null access Parameters)
     return Long_Typ_Arr_2;

   type Float_Typ_Arr_2 is new Java.Lang.Object.Root_Array
     with null record;

   function JNI_Constructor
     (Params : not null access Parameters) return Float_Typ_Arr_2;

   type Double_Typ_Arr_2 is new Java.Lang.Object.Root_Array
     with null record;

   function JNI_Constructor
     (Params : not null access Parameters) return Double_Typ_Arr_2;

end Java_Arrays;
