package %package_name% is

   type Array_Pointer is access all %array_type%;

   type Array_Pointer_Cst is access constant %array_type%;

   type Object_Pointer
     (Kind : AJIS.Internal.Java.Array_Pointer_Kind := AJIS.Internal.Java.General_Access)
   is
      record
         %bounds%

         case Kind is
            when AJIS.Internal.Java.Static =>
               Addr : System.Address;

            when AJIS.Internal.Java.General_Access =>
               General_Pointer : Array_Pointer;

            when AJIS.Internal.Java.Constant_Access =>
               Constant_Pointer : Array_Pointer_Cst;

         end case;
      end record;

   Null_Pointer : constant Object_Pointer :=
     (AJIS.Internal.Java.General_Access, %bounds_default% null);

   function Create_General_Encapsulation
     (V : Array_Pointer) return Object_Pointer;
     
   function Create_Constant_Encapsulation
     (V : Array_Pointer_Cst) return Object_Pointer;

   function Get_Address (V : Object_Pointer) return System.Address;

   function To_J_Int_J_Array
     (Env : Interfaces.Java.JNI.JNI_Env_Access;
      Obj : Object_Pointer)
      return Interfaces.Java.JNI.J_Int_J_Array;

   function To_Object_Pointer
     (Env : Interfaces.Java.JNI.JNI_Env_Access;
      Obj : Interfaces.Java.JNI.J_Int_J_Array)
      return Object_Pointer;

   procedure Free is new Ada.Unchecked_Deallocation
     (%array_type%, Array_Pointer);

end %package_name%;