------------------------------------------------------------------------------
--                                                                          --
--                     ASIS UTILITY LIBRARY COMPONENTS                      --
--                                                                          --
-- A S I S _ U L . E N V I R O N M E N T . C H E C K  _ P A R A M E T E R S --
--                                                                          --
--                                 B o d y                                  --
--                                                                          --
--                    Copyright (C) 2004-2007, AdaCore                      --
--                                                                          --
-- Asis Utility Library (ASIS UL) is free software; you can redistribute it --
-- and/or  modify  it  under  terms  of  the  GNU General Public License as --
-- published by the Free Software Foundation; either version 2, or (at your --
-- option)  any later version.  ASIS UL  is distributed in the hope that it --
-- will  be  useful,  but  WITHOUT  ANY  WARRANTY; without even the implied --
-- warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the --
-- GNU  General Public License for more details. You should have received a --
-- copy of the  GNU General Public License  distributed with GNAT; see file --
-- COPYING. If not, write to the Free Software Foundation, 59 Temple Place  --
--  - Suite 330, Boston,                                                    --
--                                                                          --
-- ASIS UL is maintained by AdaCore (http://www.adacore.com).               --
--                                                                          --
------------------------------------------------------------------------------

--  This is a placeholder for the routine that checks tool parameters. Because
--  all the checks are tool-specific, this placeholder only set up the Arg_List
--  global variable.

with Ada.Strings.Wide_Unbounded; use Ada.Strings.Wide_Unbounded;

--  8<--8<--8<--8<--8<--8<--8<--8<--8<--8<--8<--8<--
--  This is needed for multiple files driver only
with ASIS_UL.Source_Table;      use ASIS_UL.Source_Table;
-- >8-->8-->8-->8-->8-->8-->8-->8-->8-->8-->8-->8--

with Ada2Java;        use Ada2Java;
with Ada2Java.Config; use Ada2Java.Config;
with Ada2Java.Kernel; use Ada2Java.Kernel;

separate (ASIS_UL.Environment)
procedure Check_Parameters is
begin
   Trace ("Check Parameters", Debug);
   Project_Support_Type := Use_Tmp_Project_File;

   if Project_File /= null then
      Process_Project_File (Project_File.all);
   end if;

-- 8<--8<--8<--8<--8<--8<--8<--8<--8<--8<--8<--8<--
   --  This is needed for multiple files driver only

   if Last_Source < First_SF_Id then
      Error ("No input source file set");
      --  A call to Brief_Help shoul be here, but this is tool-specific
      raise Parameter_Error;
   end if;

   Total_Sources := Natural (Last_Source);
   Sources_Left  := Total_Sources;

   Set_Arg_List;
-- >8-->8-->8-->8-->8-->8-->8-->8-->8-->8-->8-->8--

   declare
      Default_Config : Configuration;
   begin
      Set_Java_Base_Package
        (Default_Config, To_Wide_String (Default_Base_Package));
      Set_Java_Class_Path
        (Default_Config, To_Wide_String (Default_Class_Path));
      Set_Ada_Output_Directory
        (Default_Config, To_Wide_String (Default_Ada_Base_Folder));
      Set_Default_Configuration (Ada2Java.The_Kernel, Default_Config);
   end;

end Check_Parameters;
