-----------------------------------------------------------------------
--                             Ada2Java                              --
--                                                                   --
--                  Copyright (C) 2007-2008, AdaCore                 --
--                                                                   --
-- Ada2Java is free software;  you can redistribute it and/or modify --
-- it under the terms of the GNU General Public License as published --
-- by the Free Software Foundation; either version 2 of the License, --
-- or (at your option) any later version.                            --
--                                                                   --
-- This program is  distributed in the hope that it will be  useful, --
-- but  WITHOUT ANY WARRANTY;  without even the  implied warranty of --
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU --
-- General Public License for more details. You should have received --
-- a copy of the GNU General Public License along with this program; --
-- if not,  write to the  Free Software Foundation, Inc.,  59 Temple --
-- Place - Suite 330, Boston, MA 02111-1307, USA.                    --
-----------------------------------------------------------------------

package body Ada2Java.Code_Wrappers is

   -------------------------
   -- Nest_Ada_Statements --
   -------------------------

   procedure Nest_Ada_Statements
     (Bloc                   : Wrapping_Bloc;
      Group_After_Statements : Boolean := True)
   is
      New_Code_Node : Dynamic_Expression := New_Dynamic_Expression;
      New_Declarations      : constant Dynamic_Expression :=
        New_Dynamic_Expression;
      New_Statements_Before : constant Dynamic_Expression :=
        New_Dynamic_Expression;
      New_Statements_After  : Dynamic_Expression := New_Dynamic_Expression;
   begin
      Append (New_Code_Node, Copy (Bloc.Code_Node));
      Empty (Bloc.Code_Node);

      Append
        (Bloc.Code_Node,
         New_Line
         & "declare" & Indent (1) & New_Declarations
         & New_Line (-1) & "begin" & Indent (1)
         & New_Statements_Before & New_Code_Node & New_Statements_After
         & New_Line (-1) & "end;");

      if Group_After_Statements then
         Append (New_Statements_After, Copy (Bloc.Statements_After));
         Append (New_Statements_After, Bloc.Statements_After);
         Empty (Bloc.Statements_After);
      end if;

      Bloc.Code_Node := New_Code_Node;
      Bloc.Declarations := New_Declarations;
      Bloc.Statements_Before := New_Statements_Before;
      Bloc.Statements_After := New_Statements_After;
   end Nest_Ada_Statements;

   -------------------------
   -- Nest_Java_Statements --
   -------------------------

   procedure Nest_Java_Statements
     (Bloc : Wrapping_Bloc; Group_After_Statements : Boolean := True)
   is
      New_Code_Node : Dynamic_Expression := New_Dynamic_Expression;
      New_Declarations      : constant Dynamic_Expression :=
        New_Dynamic_Expression;
      New_Statements_Before : constant Dynamic_Expression :=
        New_Dynamic_Expression;
      New_Statements_After  : Dynamic_Expression := New_Dynamic_Expression;
   begin
      Append (New_Code_Node, Copy (Bloc.Code_Node));
      Empty (Bloc.Code_Node);

      Append
        (Bloc.Code_Node,
         New_Declarations
         & New_Statements_Before
         & New_Code_Node & New_Statements_After);

      if Group_After_Statements then
         Append (New_Statements_After, Copy (Bloc.Statements_After));
         Append (New_Statements_After, Bloc.Statements_After);
         Empty (Bloc.Statements_After);
      end if;

      Bloc.Code_Node := New_Code_Node;
      Bloc.Declarations := New_Declarations;
      Bloc.Statements_Before := New_Statements_Before;
      Bloc.Statements_After := New_Statements_After;
   end Nest_Java_Statements;

   -----------
   -- Wrapp --
   -----------

   procedure Wrapp
     (Wrapper    : in out Indentical_Code_Wrapper;
      Expression : Wrapping_Expression;
      Parameters : access Wrapper_Parameters'Class)
   is
      pragma Unreferenced (Wrapper, Expression, Parameters);
   begin
      null;
   end Wrapp;

end Ada2Java.Code_Wrappers;
