-----------------------------------------------------------------------
--                             Ada2Java                              --
--                                                                   --
--                  Copyright (C) 2007-2008, AdaCore                 --
--                                                                   --
-- Ada2Java is free software;  you can redistribute it and/or modify --
-- it under the terms of the GNU General Public License as published --
-- by the Free Software Foundation; either version 2 of the License, --
-- or (at your option) any later version.                            --
--                                                                   --
-- This program is  distributed in the hope that it will be  useful, --
-- but  WITHOUT ANY WARRANTY;  without even the  implied warranty of --
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU --
-- General Public License for more details. You should have received --
-- a copy of the GNU General Public License along with this program; --
-- if not,  write to the  Free Software Foundation, Inc.,  59 Temple --
-- Place - Suite 330, Boston, MA 02111-1307, USA.                    --
-----------------------------------------------------------------------

with Ada2Java.Dynamic_Expressions; use Ada2Java.Dynamic_Expressions;

package body Ada2Java.Bound_Elements.References is

   ----------
   -- Bind --
   ----------

   procedure Bind
     (Handle        : not null access Kernel.Kernel_Record;
      Element       : Simple_Element_View_Access;
      Element_Bound : access Bound_Reference)
   is
      pragma Unreferenced (Element_Bound);

      Unit : constant Bound_Unit := Get_Or_Create_Bound_Unit
        (Handle => Handle,
         View   => Element);

      Type_View : constant Simple_Type_View_Access :=
        Simple_Type_View_Access (Element);

      Java_Ref_Class : Dynamic_Expression;
      Ref_Class_Name : Dynamic_Expression;
   begin
      if Type_View.Kind = Access_Kind then
         Ref_Class_Name := Type_View.Target_Type.Ref.Full_Java_Name;
      else
         Ref_Class_Name := Type_View.Full_Java_Name;
      end if;

      if Type_View.Kind = Enumeration_Kind then
         Java_Ref_Class := New_Line & New_Line
           & "public static class Ref "
           & "implements com.adacore.ajis.internal.ada.IEnumRef {"
           & New_Line (1)
           & "public " & Ref_Class_Name & " ref;"
           & New_Line & New_Line
           & "public void setValue (" & Ref_Class_Name & " r) {"
           & New_Line (1) & "ref = r;"
           & New_Line (-1) & "}"
           & New_Line & New_Line
           & "public " & Ref_Class_Name & " getValue () {"
           & New_Line (1)
           & "return ref;"
           & New_Line (-1) & "}"
           & New_Line & New_Line
           & "public void setValueInt (int value) {"
           & New_Line (1) & "ref = "
           & Ref_Class_Name & ".class.getEnumConstants () [value];"
           & New_Line (-1) & "}"
           & New_Line & New_Line
           & "public int getValueInt () {"
           & New_Line (1) & "return ref.ordinal ();"
           & New_Line (-1) & "}"
           & New_Line (-1) & "}";
      else
         Java_Ref_Class := New_Line & New_Line
           & "public static class Ref implements com.adacore.ajis.IProxyRef {"
           & New_Line (1)
           & "public " & Ref_Class_Name & " ref;"
           & New_Line & New_Line
           & "public void setValue (com.adacore.ajis.IProxy r) {"
           & New_Line (1) & "ref = (" & Ref_Class_Name & ") r;"
           & New_Line (-1) & "}"
           & New_Line & New_Line
           & "public " & Ref_Class_Name & " getValue () {"
           & New_Line (1)
           & "return ref;"
           & New_Line (-1) & "}"
           & New_Line (-1) & "}"
           & New_Line & New_Line
           & "public Ref NewProxyRef () {"
           & New_Line (1) & "Ref ref = new Ref ();"
           & New_Line & "ref.setValue (this);"
           & New_Line & "return ref;"
           & New_Line (-1) & "}";
      end if;

      Append (Unit.Java_File.Public_Body_Part, Java_Ref_Class);
   end Bind;

end Ada2Java.Bound_Elements.References;
