-----------------------------------------------------------------------
--                             Ada2Java                              --
--                                                                   --
--                  Copyright (C) 2007-2008, AdaCore                 --
--                                                                   --
-- Ada2Java is free software;  you can redistribute it and/or modify --
-- it under the terms of the GNU General Public License as published --
-- by the Free Software Foundation; either version 2 of the License, --
-- or (at your option) any later version.                            --
--                                                                   --
-- This program is  distributed in the hope that it will be  useful, --
-- but  WITHOUT ANY WARRANTY;  without even the  implied warranty of --
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU --
-- General Public License for more details. You should have received --
-- a copy of the GNU General Public License along with this program; --
-- if not,  write to the  Free Software Foundation, Inc.,  59 Temple --
-- Place - Suite 330, Boston, MA 02111-1307, USA.                    --
-----------------------------------------------------------------------

package Ada2Java.Bound_Elements.Callbacks is

   function Create_Bound_Callback
     (Element : Simple_Element_View_Access) return Bound_Element;

   type Bound_Callback is new Bound_Element_Record with private;

   procedure Bind
     (Handle        : not null access Kernel.Kernel_Record;
      Element       : Simple_Element_View_Access;
      Element_Bound : access Bound_Callback);
   --  See default implementation

   function Get_Default_Implementation_Unit
     (Element_Bound : access Bound_Callback) return Bound_Unit;
   --  Return the unit holding the default implementation of this callback,
   --  able to call an ada-implemented procedure.

   function Get_Ada_High_Name
     (Element_Bound : access Bound_Callback) return Dynamic_Expression;
   --  Return the name of the high ada name of this callback.

private

   type Bound_Callback is new Bound_Element_Record with record
      Ada_High_Name          : Dynamic_Expression;
      Child_Wrapper_Type     : Wide_String_Access;
      Default_Implementation : Bound_Unit := null;
   end record;

end Ada2Java.Bound_Elements.Callbacks;
