package com.adacore.ajis.examples.philosophers;

import java.awt.GridLayout;
import java.awt.Rectangle;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;

import javax.swing.JFrame;
import javax.swing.JPanel;

import com.adacore.ajis.IProxy.Owner;
import com.adacore.ajis.examples.philosophers.Room.Room_Package;
import com.adacore.ajis.examples.philosophers.Society.Society_Package;

public class Main {	
	
	/**
	 * @param args
	 */
	public static void main(String[] args) {
		JFrame frame = new JFrame("Philosophers");		
		
		frame.addWindowListener(new WindowAdapter() {
			@Override
			public void windowClosing(WindowEvent e) {
				System.exit(0);
			}
		});
		
		frame.getContentPane().setLayout(new GridLayout (3, 1));		

		JPanel line1 = new JPanel ();
		JPanel line2 = new JPanel ();
		JPanel line3 = new JPanel ();
		
		line1.setLayout(new GridLayout (1, 1));
		line2.setLayout(new GridLayout (1, 2));
		line3.setLayout(new GridLayout (1, 2));
		
		frame.getContentPane().add(line1);
		frame.getContentPane().add(line2);
		frame.getContentPane().add(line3);
		
		PhilosopherPanel [] pannels = new PhilosopherPanel [5];
		
		pannels [0] = new PhilosopherPanel(line1, Society_Package.Name_Register()
				.Get_Element_At(1).toString());
		
		pannels [1] = new PhilosopherPanel (line2, Society_Package.Name_Register()
				.Get_Element_At(2).toString());
		pannels [2] = new PhilosopherPanel (line2, Society_Package.Name_Register()
				.Get_Element_At(3).toString());
		
		pannels [3] = new PhilosopherPanel (line3, Society_Package.Name_Register()
				.Get_Element_At(4).toString());
		pannels [4] = new PhilosopherPanel (line3, Society_Package.Name_Register()
				.Get_Element_At(5).toString());		
		
		frame.pack();
		frame.setBounds(new Rectangle (500, 400));
		frame.setLocationRelativeTo(null);
		frame.setVisible(true);		
		
		JavaStateReporter reporter = new JavaStateReporter (pannels);
		reporter.setOwner(Owner.NATIVE);
		
		Room_Package.Reporter(reporter);
		
		Room_Package.Start_Serving();
	}

}
