//////////////////////////////////////////////////////////////////////////////
//                                                                          //
//                                  AJIS                                    //
//                                                                          //
//                     Copyright (C) 2007-2008, AdaCore                     //
//                                                                          //
// GNAT is free software;  you can  redistribute it  and/or modify it under //
// terms of the  GNU General Public License as published  by the Free Soft- //
// ware  Foundation;  either version 2,  or (at your option) any later ver- //
// sion.  GNAT is distributed in the hope that it will be useful, but WITH- //
// OUT ANY WARRANTY;  without even the  implied warranty of MERCHANTABILITY //
// or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License //
// for  more details.  You should have  received  a copy of the GNU General //
// Public License  distributed with GNAT;  see file COPYING.  If not, write //
// to  the  Free Software Foundation,  51  Franklin  Street,  Fifth  Floor, //
// Boston, MA 02110-1301, USA.                                              //
//                                                                          //
//                                                                          //
//                                                                          //
//                                                                          //
//                                                                          //
//                                                                          //
//                                                                          //
//                                                                          //
//                                                                          //
//////////////////////////////////////////////////////////////////////////////

package com.adacore.ajis;

public interface IProxy extends Cloneable, IEscapable {

	public enum Owner {PROXY, NATIVE};
	
	public enum Allocator {STATIC, DYNAMIC, UNKNOWN}
	
	/**
	 * Create a new object indirect reference to the proxy.
	 */
	public IProxyRef NewProxyRef ();
	
	/**
	 * Set whether the native object is owned by the proxy, and thus needs to
	 * be freed on finalize. Objects allocated statically cannot change their
	 * owner.
	 */
	public void setOwner (Owner theOwner);

	/**
	 * return whether the owner of the native object
	 */
	public Owner getOwner ();
	
	/**
	 * Return the kind of allocator used to produce the native data of this
	 * proxy.
	 */
	public Allocator getAllocator ();
	
	/**
	 * This function is called whenever the proxy is copied. Clone is only
	 * 	called when the object is copied from Java, not from Ada. The native
	 *  object may not have been already linked to the proxy, so calls to
	 *  bound primitives should be avoided at this stage.
	 */
	public void proxyCloned (IProxy initialObject);
	
	/**
	 * Force the deallocation of the native object. This does not take into
	 * account the owning attribute of the string. The user must ensure that
	 * the object have been created on the heap, otherwise memory corruptions
	 * will occure. Using the standard owning mechanism should be prefered than
	 * directly calling deallocation whenever possible.
	 */
	public void deallocateNativeObject ();
}
