package com.adacore.ajis.examples.philosophers;

import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.LayoutManager;

import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class PhilosopherPanel {
	
	private JPanel panel;
	private JLabel nameLabel;
	private JLabel [] stateLabels;
	
	public PhilosopherPanel (Container container, String name) {
		panel = new JPanel ();
		
		LayoutManager layout = new FlowLayout (FlowLayout.CENTER);
		panel.setLayout(layout);
		
		JPanel subPanel = new JPanel ();
		subPanel.setLayout(new BoxLayout (subPanel, BoxLayout.Y_AXIS));

		nameLabel = new JLabel (name);		
		subPanel.add(nameLabel);
		subPanel.add(new JLabel (" "));
		
		stateLabels = new JLabel [3];
		
		for (int j = 0; j < stateLabels.length; ++j) {
			stateLabels [j] = new JLabel ();		
			subPanel.add(stateLabels [j]);		
		}				
		
		panel.validate();
		
		panel.add(subPanel);
		container.add(panel);
	}
	
	public void registerEvent (String event) {
		for (int j = 0; j < stateLabels.length - 1; ++j) {
			stateLabels [j].setText(stateLabels [j + 1].getText());
		}

		stateLabels [stateLabels.length - 1].setText(event);
		
		panel.validate();
		
	}

}
