------------------------------------------------------------------------------
--                                                                          --
--                     ASIS UTILITY LIBRARY COMPONENTS                      --
--                                                                          --
--                      A S I S _ U L . O P T I O N S                       --
--                                                                          --
--                                 S p e c                                  --
--                                                                          --
--                     Copyright (C) 2004-2013, AdaCore                     --
--                                                                          --
-- Asis Utility Library (ASIS UL) is free software; you can redistribute it --
-- and/or  modify  it  under  terms  of  the  GNU General Public License as --
-- published by the Free Software Foundation; either version 2, or (at your --
-- option)  any later version.  ASIS UL  is distributed in the hope that it --
-- will  be  useful,  but  WITHOUT  ANY  WARRANTY; without even the implied --
-- warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the --
-- GNU  General Public License for more details. You should have received a --
-- copy of the  GNU General Public License  distributed with GNAT; see file --
-- COPYING.  If not,  write  to the  Free Software Foundation,  51 Franklin --
-- Street, Fifth Floor, Boston, MA 02110-1301, USA.                         --
--                                                                          --
-- ASIS UL is maintained by AdaCore (http://www.adacore.com).               --
--                                                                          --
------------------------------------------------------------------------------

--  This package defines options that are supposed to be of a common interest
--  for all the tools.

with GNAT.OS_Lib; use GNAT.OS_Lib;

with ASIS_UL.Debug;

package ASIS_UL.Options is

   Print_Version : Boolean := False;
   --  '--version'
   --  Print version info and exit

   Print_Usage : Boolean := False;
   --  '--help'
   --  Print usage info and exit

   Verbose_Mode : Boolean := False;
   --  The verbose mode.
   --  '-v'

   Quiet_Mode : Boolean := False;
   --  The quiet mode
   --  '-q'
   --  !!! At some point we have to get rid of this flag and to use only
   --  fine tuned debug options defined by the flags in ASIS_UL.Debug.

   Debug_Mode : Boolean := False;
   --  The debug mode
   --  '-d'

   Progress_Indicator_Mode : Boolean renames ASIS_UL.Debug.Debug_Flag_D;
   --  Generate the output to be used for GPS progress indicator.
   --  '-dd'

   Generate_XML_Help : Boolean := False;
   --  If this file is ON, the tool generates the XML description of the tool
   --  parameters to be used for creating the GUI in GPS.
   --  '-hx'.

   Compute_Timing : Boolean := False;
   --  If this flag is ON, the total execution time (wall clock) of the tool
   --  is computed and printed out.
   --  '-t'

   type Warning_Modes is
     (Quiet,  --  all warnings are suppressed
      Short,
      Normal,
      Full);

   Warning_Mode : Warning_Modes := Normal;
   --  Specifies the warning message level
   --  '-w(q|s|n|f)

   Log_Mode : Boolean := False;
   --  Create the log file and duplicate in this file all the messages
   --  generated by a tool.
   --  '-log'

   Test_Mode : Boolean := False;
   --  Run the tool in a test mode that is suitable for Q4A massive test
   --  driver. The details of the test mode are tool-specific and should be
   --  set in the tool.
   --  '--test'

   Process_Num : Natural := 1;
   --  The maximal number of parallel tree creations
   --  -jN

   ----------------------------------------
   -- Flags computed from other settings --
   ----------------------------------------

   --  The flags listed below are not set by some options, but they are
   --  computed from gnatcheck command line and rule options

   No_Argument_File_Specified : Boolean := True;
   --  Flag indicating if no argument file is specified for the tool call.
   --  Usually the tool generated the brief help info in this case.

   Nothing_To_Do : Boolean := False;
   --  Flag indicating if a tool does not have any real work to do - that is,
   --  that there are some argument files specified, and there is at least one
   --  argument file that exists. A tool should not rely on the default setting
   --  of this file.

   ------------------------------------------------------
   -- options related to program global state analysis --
   ------------------------------------------------------

   Process_RTL_Units : Boolean := False;
   --  If this flag is set ON, a tool tries to look into RTL units when
   --  analyzing global properties of the argument sources, even if these RTL
   --  units are not specified as tool arguments
   --  '-a'

   Generate_Global_Structure_Warnings : Boolean := False;
   --  Generate warning messages in case if a problem that prevents the
   --  complete analyzis of the program global structure is detected

   Buld_Call_Graph : Boolean := False;
   --  Flag indicating if we have to collect the call graph information.

   Do_Transitive_Closure : Boolean := False;
   --  Flag indicating if the transitive closure of the call graph is needed.

   Collect_Data_Info : Boolean := False;
   --  Flag indicating if the data information should be included into the
   --  program global structure representation

   Main_Subprogram_Name : String_Access;
   --  -main=<name of the main subprogram>
   --  The name of the source file containing the main subprogram. The name
   --  may or may not contain the suffix. This subprogram is called by the
   --  environment task.

   --  More flags? Flags to represent type?

   Represent_Dispatching_Calls : Boolean := True;
   --  If this flag is ON, the call graph represents the dispatching calls.
   --  This flag should be removed after completing the implementation of
   --  dispatching calls representation in the call graph.

end ASIS_UL.Options;
