------------------------------------------------------------------------------
--                                 Ada2Java                                 --
--                                                                          --
--                     Copyright (C) 2007-2013, AdaCore                     --
--                                                                          --
-- This is free software;  you can redistribute it  and/or modify it  under --
-- terms of the  GNU General Public License as published  by the Free Soft- --
-- ware  Foundation;  either version 3,  or (at your option) any later ver- --
-- sion.  This software is distributed in the hope  that it will be useful, --
-- but WITHOUT ANY WARRANTY;  without even the implied warranty of MERCHAN- --
-- TABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public --
-- License for  more details.  You should have  received  a copy of the GNU --
-- General  Public  License  distributed  with  this  software;   see  file --
-- COPYING3.  If not, go to http://www.gnu.org/licenses for a complete copy --
-- of the license.                                                          --
------------------------------------------------------------------------------

package Ada2Java.Bound_Elements.Callbacks is

   function Create_Bound_Callback
     (Element : Simple_Element_View_Access) return Bound_Element;

   type Bound_Callback is new Bound_Element_Record with private;

   overriding
   procedure Initialize
     (Handle        : not null access Kernel.Kernel_Record;
      Element       : Simple_Element_View_Access;
      Element_Bound : access Bound_Callback);

   overriding
   procedure Bind
     (Element_Bound : access Bound_Callback;
      Handle        : not null access Kernel.Kernel_Record);
   --  See default implementation

   function Get_Default_Implementation_Unit_Name
     (Element_Bound : access Bound_Callback) return Dynamic_Expression;
   --  Return the unit holding the default implementation of this callback,
   --  able to call an Ada-implemented procedure.

   function Get_Ada_High_Name
     (Element_Bound : access Bound_Callback) return Dynamic_Expression;
   --  Return the name of the high Ada name of this callback.

private

   type Bound_Callback is new Bound_Element_Record with record
      Child_Wrapper_Type          : Wide_String_Access;
      Default_Implementation_Name : Dynamic_Expression;
   end record;

end Ada2Java.Bound_Elements.Callbacks;
