------------------------------------------------------------------------------
--                                 J N I                                    --
--                                                                          --
--                        Copyright (C) 2007, AdaCore                       --
--                                                                          --
-- This is free software;  you can  redistribute it  and/or modify it under --
-- terms of the  GNU General Public License as published  by the Free Soft- --
-- ware  Foundation;  either version 2,  or (at your option) any later ver- --
-- sion.  GNAT is distributed in the hope that it will be useful, but WITH- --
-- OUT ANY WARRANTY;  without even the  implied warranty of MERCHANTABILITY --
-- or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License --
-- for  more details.  You should have  received  a copy of the GNU General --
-- Public License  distributed with GNAT;  see file COPYING.  If not, write --
-- to  the  Free Software Foundation,  51  Franklin  Street,  Fifth  Floor, --
-- Boston, MA 02110-1301, USA.                                              --
------------------------------------------------------------------------------

with Interfaces.C.Strings; use Interfaces.C.Strings;
with JNI;                  use JNI;
with JNI_JVM;              use JNI_JVM;
with JNI_Object;           use JNI_Object;
with Java.Lang.String;     use Java.Lang.String;

package body Java_Strings is

   ----------------
   -- New_String --
   ----------------

   function New_String (S : String) return access Java.Lang.String.Typ'Class is
      Env                : aliased JNI_Env_Access;
      I                  : J_Int;
      Internal_Chars_Ptr : chars_ptr;
      Internal_J_String  : J_String;
   begin
      I := Get_Env
        (VM   => Current_VM,
         Penv => Env'Access);
      if I /= JNI_OK then
         raise Program_Error with "Cannot get the JNI_Env.";
      end if;

      Internal_Chars_Ptr := New_String (S);
      Internal_J_String := New_String_UTF (Env, Internal_Chars_Ptr);

      Free (Internal_Chars_Ptr);

      return Java.Lang.String.String
        (Create_Ada_Object (J_Object (Internal_J_String)));
   end New_String;

   ----------------
   -- Get_String --
   ----------------

   function Get_String (S : access Java.Lang.String.Typ'Class) return String is
      Env                : aliased JNI_Env_Access;
      I                  : J_Int;
      Internal_Chars_Ptr : chars_ptr;
      Internal_J_String  : J_String;
   begin
      I := Get_Env
        (VM   => Current_VM,
         Penv => Env'Access);
      if I /= JNI_OK then
         raise Program_Error with "Cannot get the JNI_Env.";
      end if;

      Internal_J_String := J_String (Get_J_Object (JNI_Data (S.all)));
      Internal_Chars_Ptr := Get_String_UTF_Chars (Env, Internal_J_String);

      declare
         The_String : constant String := Value (Internal_Chars_Ptr);
      begin
         Release_String_UTF_Chars (Env, Internal_J_String, Internal_Chars_Ptr);
         return The_String;
      end;
   end Get_String;

end Java_Strings;
