------------------------------------------------------------------------------
--                                 Ada2Java                                 --
--                                                                          --
--                     Copyright (C) 2007-2012, AdaCore                     --
--                                                                          --
-- This is free software;  you can redistribute it  and/or modify it  under --
-- terms of the  GNU General Public License as published  by the Free Soft- --
-- ware  Foundation;  either version 3,  or (at your option) any later ver- --
-- sion.  This software is distributed in the hope  that it will be useful, --
-- but WITHOUT ANY WARRANTY;  without even the implied warranty of MERCHAN- --
-- TABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public --
-- License for  more details.  You should have  received  a copy of the GNU --
-- General  Public  License  distributed  with  this  software;   see  file --
-- COPYING3.  If not, go to http://www.gnu.org/licenses for a complete copy --
-- of the license.                                                          --
------------------------------------------------------------------------------

with Ada.Text_IO; use Ada.Text_IO;
with Ada.Wide_Text_IO; use Ada.Wide_Text_IO;

with Asis;                        use Asis;
with Asis.Elements;               use Asis.Elements;
with Asis.Text;                   use Asis.Text;

package body Debug_Tools is

   procedure Print_Element (E : Asis.Element) is
   begin
      Put_Line (Element_Image (E));
      Put ("Element_Kind  (" & Element_Kinds'Image (Element_Kind (E)) & ")");

      if Pragma_Kind (E) /= Not_A_Pragma then
         Put (", Pragma_Kind ("
              & Pragma_Kinds'Image (Pragma_Kind (E))
              & ")");
      end if;

      if Defining_Name_Kind (E) /= Not_A_Defining_Name then
         Put (", Defining_Name_Kind ("
              & Defining_Name_Kinds'Image (Defining_Name_Kind (E))
              & ")");
      end if;

      if Declaration_Kind (E) /= Not_A_Declaration then
         Put (", Declaration_Kind ("
              & Declaration_Kinds'Image (Declaration_Kind (E))
              & ")");
      end if;

      if Trait_Kind (E) /= Not_A_Trait then
         Put (", Trait_Kind ("
              & Trait_Kinds'Image (Trait_Kind (E))
              & ")");
      end if;

      if Declaration_Origin (E) /= Not_A_Declaration_Origin then
         Put (", Declaration_Origin ("
              & Declaration_Origins'Image (Declaration_Origin (E))
              & ")");
      end if;

      if Mode_Kind (E) /= Not_A_Mode then
         Put (", Mode_Kind ("
              & Mode_Kinds'Image (Mode_Kind (E))
              & ")");
      end if;

      if Definition_Kind (E) /= Not_A_Definition then
         Put (", Definition_Kind ("
              & Definition_Kinds'Image (Definition_Kind (E))
              & ")");
      end if;

      if Type_Kind (E) /= Not_A_Type_Definition then
         Put (", Type_Kind ("
              & Type_Kinds'Image (Type_Kind (E))
              & ")");
      end if;

      if Formal_Type_Kind (E) /= Not_A_Formal_Type_Definition then
         Put (", Formal_Type_Kind ("
              & Formal_Type_Kinds'Image (Formal_Type_Kind (E))
              & ")");
      end if;

      if Access_Type_Kind (E) /= Not_An_Access_Type_Definition then
         Put (", Access_Type_Kind ("
              & Access_Type_Kinds'Image (Access_Type_Kind (E))
              & ")");
      end if;

      if Root_Type_Kind (E) /= Not_A_Root_Type_Definition then
         Put (", Root_Type_Kind ("
              & Root_Type_Kinds'Image (Root_Type_Kind (E))
              & ")");
      end if;

      if Constraint_Kind (E) /= Not_A_Constraint then
         Put (", Constraint_Kind ("
              & Constraint_Kinds'Image (Constraint_Kind (E))
              & ")");
      end if;

      if Discrete_Range_Kind (E) /= Not_A_Discrete_Range then
         Put (", Discrete_Range_Kind ("
              & Discrete_Range_Kinds'Image (Discrete_Range_Kind (E))
              & ")");
      end if;

      if Association_Kind (E) /= Not_An_Association then
         Put (", Association_Kind ("
              & Association_Kinds'Image (Association_Kind (E))
              & ")");
      end if;

      if Expression_Kind (E) /= Not_An_Expression then
         Put (", Expression_Kind ("
              & Expression_Kinds'Image (Expression_Kind (E))
              & ")");
      end if;

      if Operator_Kind (E) /= Not_An_Operator then
         Put (", Operator_Kind ("
              & Operator_Kinds'Image (Operator_Kind (E))
              & ")");
      end if;

      if Attribute_Kind (E) /= Not_An_Attribute then
         Put (", Attribute_Kind ("
              & Attribute_Kinds'Image (Attribute_Kind (E))
              & ")");
      end if;

      if Statement_Kind (E) /= Not_A_Statement then
         Put (", Statement_Kind ("
              & Statement_Kinds'Image (Statement_Kind (E))
              & ")");
      end if;

      if Path_Kind (E) /= Not_A_Path then
         Put (", Path_Kind ("
              & Path_Kinds'Image (Path_Kind (E))
              & ")");
      end if;

      if Clause_Kind (E) /= Not_A_Clause then
         Put (", Clause_Kind ("
              & Clause_Kinds'Image (Clause_Kind (E))
              & ")");
      end if;

      if Representation_Clause_Kind (E) /= Not_A_Representation_Clause then
         Put (", Representation_Clause_Kind ("
              & Representation_Clause_Kinds'Image
                (Representation_Clause_Kind (E))
              & ")");
      end if;

      if Interface_Kind (E) /= Not_An_Interface then
         Put (", Interface_Kind ("
              & Interface_Kinds'Image (Interface_Kind (E))
              & ")");
      end if;

      Ada.Text_IO.New_Line;
   end Print_Element;

end Debug_Tools;
