------------------------------------------------------------------------------
--                                 Ada2Java                                 --
--                                                                          --
--                     Copyright (C) 2007-2012, AdaCore                     --
--                                                                          --
-- This is free software;  you can redistribute it  and/or modify it  under --
-- terms of the  GNU General Public License as published  by the Free Soft- --
-- ware  Foundation;  either version 3,  or (at your option) any later ver- --
-- sion.  This software is distributed in the hope  that it will be useful, --
-- but WITHOUT ANY WARRANTY;  without even the implied warranty of MERCHAN- --
-- TABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public --
-- License for  more details.  You should have  received  a copy of the GNU --
-- General  Public  License  distributed  with  this  software;   see  file --
-- COPYING3.  If not, go to http://www.gnu.org/licenses for a complete copy --
-- of the license.                                                          --
------------------------------------------------------------------------------

package body Ada2Java.Code_Wrappers is

   -------------------------
   -- Nest_Ada_Statements --
   -------------------------

   procedure Nest_Ada_Statements
     (Bloc                   : Wrapping_Bloc;
      Group_After_Statements : Boolean := True)
   is
      New_Code_Node : Dynamic_Expression := New_Dynamic_Expression;
      New_Declarations      : constant Dynamic_Expression :=
        New_Dynamic_Expression;
      New_Statements_Before : constant Dynamic_Expression :=
        New_Dynamic_Expression;
      New_Statements_After  : Dynamic_Expression := New_Dynamic_Expression;
   begin
      Append (New_Code_Node, Copy (Bloc.Code_Node));
      Empty (Bloc.Code_Node);

      Append
        (Bloc.Code_Node,
         New_Line
         & "declare" & Indent (1) & New_Declarations
         & New_Line (-1) & "begin" & Indent (1)
         & New_Statements_Before & New_Code_Node & New_Statements_After
         & New_Line (-1) & "end;");

      if Group_After_Statements then
         Append (New_Statements_After, Copy (Bloc.Statements_After));
         Append (New_Statements_After, Bloc.Statements_After);
         Empty (Bloc.Statements_After);
      end if;

      Bloc.Code_Node := New_Code_Node;
      Bloc.Declarations := New_Declarations;
      Bloc.Statements_Before := New_Statements_Before;
      Bloc.Statements_After := New_Statements_After;
   end Nest_Ada_Statements;

   -------------------------
   -- Nest_Java_Statements --
   -------------------------

   procedure Nest_Java_Statements
     (Bloc : Wrapping_Bloc; Group_After_Statements : Boolean := True)
   is
      New_Code_Node : Dynamic_Expression := New_Dynamic_Expression;
      New_Declarations      : constant Dynamic_Expression :=
        New_Dynamic_Expression;
      New_Statements_Before : constant Dynamic_Expression :=
        New_Dynamic_Expression;
      New_Statements_After  : Dynamic_Expression := New_Dynamic_Expression;
   begin
      Append (New_Code_Node, Copy (Bloc.Code_Node));
      Empty (Bloc.Code_Node);

      Append
        (Bloc.Code_Node,
         New_Declarations
         & New_Statements_Before
         & New_Code_Node & New_Statements_After);

      if Group_After_Statements then
         Append (New_Statements_After, Copy (Bloc.Statements_After));
         Append (New_Statements_After, Bloc.Statements_After);
         Empty (Bloc.Statements_After);
      end if;

      Bloc.Code_Node := New_Code_Node;
      Bloc.Declarations := New_Declarations;
      Bloc.Statements_Before := New_Statements_Before;
      Bloc.Statements_After := New_Statements_After;
   end Nest_Java_Statements;

   ----------
   -- Wrap --
   ----------

   procedure Wrap
     (Wrapper    : in out Indentical_Code_Wrapper;
      Expression : Wrapping_Expression;
      Parameters : access Wrapper_Parameters'Class)
   is
      pragma Unreferenced (Wrapper, Expression, Parameters);
   begin
      null;
   end Wrap;

end Ada2Java.Code_Wrappers;
