------------------------------------------------------------------------------
--                                 Ada2Java                                 --
--                                                                          --
--                     Copyright (C) 2007-2012, AdaCore                     --
--                                                                          --
-- This is free software;  you can redistribute it  and/or modify it  under --
-- terms of the  GNU General Public License as published  by the Free Soft- --
-- ware  Foundation;  either version 3,  or (at your option) any later ver- --
-- sion.  This software is distributed in the hope  that it will be useful, --
-- but WITHOUT ANY WARRANTY;  without even the implied warranty of MERCHAN- --
-- TABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public --
-- License for  more details.  You should have  received  a copy of the GNU --
-- General  Public  License  distributed  with  this  software;   see  file --
-- COPYING3.  If not, go to http://www.gnu.org/licenses for a complete copy --
-- of the license.                                                          --
------------------------------------------------------------------------------

package Ada2Java.Code_Wrappers.Test is

   type Returning_Code_Wrapper is new Code_Wrapper with null record;

   procedure Wrap
     (Wrapper           : in out Returning_Code_Wrapper;
      Expression        : in out Dynamic_Expression;
      Code_Node         : in out Dynamic_Expression;
      Declarations      : in out Dynamic_Expression;
      Statements_Before : in out Dynamic_Expression;
      Statements_After  : in out Dynamic_Expression);

   type Full_Code_Wrapper is new Code_Wrapper with null record;

   procedure Wrap
     (Wrapper           : in out Full_Code_Wrapper;
      Expression        : in out Dynamic_Expression;
      Code_Node         : in out Dynamic_Expression;
      Declarations      : in out Dynamic_Expression;
      Statements_Before : in out Dynamic_Expression;
      Statements_After  : in out Dynamic_Expression);

   type If_Code_Wrapper is new Code_Wrapper with null record;

   procedure Wrap
     (Wrapper           : in out If_Code_Wrapper;
      Expression        : in out Dynamic_Expression;
      Code_Node         : in out Dynamic_Expression;
      Declarations      : in out Dynamic_Expression;
      Statements_Before : in out Dynamic_Expression;
      Statements_After  : in out Dynamic_Expression);

end Ada2Java.Code_Wrappers.Test;
