------------------------------------------------------------------------------
--                                 Ada2Java                                 --
--                                                                          --
--                     Copyright (C) 2007-2012, AdaCore                     --
--                                                                          --
-- This is free software;  you can redistribute it  and/or modify it  under --
-- terms of the  GNU General Public License as published  by the Free Soft- --
-- ware  Foundation;  either version 3,  or (at your option) any later ver- --
-- sion.  This software is distributed in the hope  that it will be useful, --
-- but WITHOUT ANY WARRANTY;  without even the implied warranty of MERCHAN- --
-- TABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public --
-- License for  more details.  You should have  received  a copy of the GNU --
-- General  Public  License  distributed  with  this  software;   see  file --
-- COPYING3.  If not, go to http://www.gnu.org/licenses for a complete copy --
-- of the license.                                                          --
------------------------------------------------------------------------------

package body Ada2Java.Code_Wrappers.Test is

   -----------
   -- Wrap --
   -----------

   procedure Wrap
     (Wrapper           : in out Returning_Code_Wrapper;
      Expression        : in out Dynamic_Expression;
      Code_Node         : in out Dynamic_Expression;
      Declarations      : in out Dynamic_Expression;
      Statements_Before : in out Dynamic_Expression;
      Statements_After  : in out Dynamic_Expression)
   is
      pragma Unreferenced (Wrapper, Code_Node, Statements_Before);
   begin
      Append
        (Declarations,
         New_Line & "Ret : Integer := " & Expression & ";");
      Append (Statements_After, New_Line & "return Ret;");

      Expression := To_Dynamic_Expression ("Ret");
   end Wrap;

   ----------
   -- Wrap --
   ----------

   procedure Wrap
     (Wrapper           : in out Full_Code_Wrapper;
      Expression        : in out Dynamic_Expression;
      Code_Node         : in out Dynamic_Expression;
      Declarations      : in out Dynamic_Expression;
      Statements_Before : in out Dynamic_Expression;
      Statements_After  : in out Dynamic_Expression)
   is
      pragma Unreferenced (Wrapper);
   begin
      Append
        (Declarations,
         New_Line & "X : Integer;");
      Append
        (Statements_Before, New_Line & "X := " & Expression & ";");
      Append (Statements_After, New_Line & "X := 0;");

      Expression := To_Dynamic_Expression ("X");

      Nest_Ada_Statements
        (Code_Node         => Code_Node,
         Declarations      => Declarations,
         Statements_Before => Statements_Before,
         Statements_After  => Statements_After);
   end Wrap;

   ----------
   -- Wrap --
   ----------

   procedure Wrap
     (Wrapper           : in out If_Code_Wrapper;
      Expression        : in out Dynamic_Expression;
      Code_Node         : in out Dynamic_Expression;
      Declarations      : in out Dynamic_Expression;
      Statements_Before : in out Dynamic_Expression;
      Statements_After  : in out Dynamic_Expression)
   is
      pragma Unreferenced (Wrapper);

      New_Code_Node : Dynamic_Expression := New_Dynamic_Expression;

      Variant_Part : constant Dynamic_Expression := New_Dynamic_Expression;
   begin
      Append (Expression, " + " & Variant_Part);

      New_Code_Node := Copy (Code_Node);
      Empty (Code_Node);

      Append
        (Code_Node, New_Line
         & To_Dynamic_Expression ("if cond then")
         & Indent (1)
         & Set_Expression (Variant_Part, To_Dynamic_Expression ("Case_1"))
         & New_Code_Node
         & New_Line (-1) & "else"
         & Indent (1)
         & Set_Expression (Variant_Part, To_Dynamic_Expression ("Case_2"))
         & New_Code_Node
         & New_Line (-1) & "end if;");

      Code_Node := New_Code_Node;

      Nest_Ada_Statements
        (Code_Node         => Code_Node,
         Declarations      => Declarations,
         Statements_Before => Statements_Before,
         Statements_After  => Statements_After);
   end Wrap;

end Ada2Java.Code_Wrappers.Test;
