------------------------------------------------------------------------------
--                                 Ada2Java                                 --
--                                                                          --
--                     Copyright (C) 2008-2012, AdaCore                     --
--                                                                          --
-- This is free software;  you can redistribute it  and/or modify it  under --
-- terms of the  GNU General Public License as published  by the Free Soft- --
-- ware  Foundation;  either version 3,  or (at your option) any later ver- --
-- sion.  This software is distributed in the hope  that it will be useful, --
-- but WITHOUT ANY WARRANTY;  without even the implied warranty of MERCHAN- --
-- TABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public --
-- License for  more details.  You should have  received  a copy of the GNU --
-- General  Public  License  distributed  with  this  software;   see  file --
-- COPYING3.  If not, go to http://www.gnu.org/licenses for a complete copy --
-- of the license.                                                          --
------------------------------------------------------------------------------

package Ada2Java.Bound_Elements.Enums is

   type Bound_Enum is new Bound_Element_Record with private;
   --  This types holds data related to the binding of enumeration types.

   overriding
   procedure Initialize
     (Handle        : not null access Kernel.Kernel_Record;
      Element       : Simple_Element_View_Access;
      Element_Bound : access Bound_Enum);

   overriding
   procedure Bind
     (Element_Bound : access Bound_Enum;
      Handle        : not null access Kernel.Kernel_Record);

private

   type Bound_Enum is new Bound_Element_Record with record
      Ref_Constructor_Id : Dynamic_Expression;
   end record;

end Ada2Java.Bound_Elements.Enums;
