------------------------------------------------------------------------------
--                                                                          --
--                      GNAT METRICS TOOLS COMPONENTS                       --
--                                                                          --
--           A S I S _ U L . M E T R I C S . F L O W _ G R A P H            --
--                                                                          --
--                                 S p e c                                  --
--                                                                          --
--                       Copyright (C) 2011, AdaCore                        --
--                                                                          --
-- GNAT Metrics Toolset  is free software;  you can  redistribute it and/or --
-- modify it under terms of the  GNU General Public License as published by --
-- the Free Software Foundation;  either version 2, or (at your option) any --
-- later version.  GNAT Metrics Toolset is  distributed in the hope that it --
-- will be useful, but  WITHOUT ANY WARRANTY; without even the implied war- --
-- ranty of  MERCHANTABILITY or  FITNESS FOR A PARTICULAR PURPOSE.  See the --
-- GNU General Public License for more details.  You should have received a --
-- copy of the  GNU General Public License distributed with  GNAT; see file --
-- COPYING.  If not,  write to the  Free Software  Foundation,  51 Franklin --
-- Street, Fifth Floor, Boston, MA 02110-1301, USA.                         --
--                                                                          --
-- GNAT Metrics Toolset is maintained by AdaCore (http://www.adacore.com).  --
--                                                                          --
------------------------------------------------------------------------------

--  This package defines routines for constructing the control flow graph
--  needed for computing McCabe's essential complexity metric. The graph is
--  created already in partly reduced form (it does not contain structures for
--  control statements that are purely structural), so it can hardly be reused
--  for other purposes.

with Asis;                        use Asis;
with ASIS_UL.Metrics.Definitions; use ASIS_UL.Metrics.Definitions;

package ASIS_UL.Metrics.Flow_Graph is

   function Compute_Essential_Complexity
     (Body_Element : Asis.Element)
      return         Metric_Count;
   --  Encapsulates all the steps needed to compute the essential complexity
   --  for a body: building the control flow graph, reducing it and computing
   --  the metric from the reduced graph.

end ASIS_UL.Metrics.Flow_Graph;
