------------------------------------------------------------------------------
--                                                                          --
--                                 J N I                                    --
--                                                                          --
--                        Copyright (C) 2007, AdaCore                       --
--                                                                          --
-- This is free software;  you can  redistribute it  and/or modify it under --
-- terms of the  GNU General Public License as published  by the Free Soft- --
-- ware  Foundation;  either version 2,  or (at your option) any later ver- --
-- sion.  GNAT is distributed in the hope that it will be useful, but WITH- --
-- OUT ANY WARRANTY;  without even the  implied warranty of MERCHANTABILITY --
-- or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License --
-- for  more details.  You should have  received  a copy of the GNU General --
-- Public License  distributed with GNAT;  see file COPYING.  If not, write --
-- to  the  Free Software Foundation,  51  Franklin  Street,  Fifth  Floor, --
-- Boston, MA 02110-1301, USA.                                              --
--                                                                          --
------------------------------------------------------------------------------

with Ada.Text_IO; use Ada.Text_IO;
with Test1;       use Test1;

package body Test1_JNI is

   ----------
   -- test --
   ----------

   procedure test (Env : JNI_Env_Access; Obj : J_Object) is
      pragma Unreferenced (Env, Obj);
   begin
      Test;
   end test;

   -----------
   -- test2 --
   -----------

   procedure test2 (Env : JNI_Env_Access; Obj : J_Object; P1 : J_Int) is
      pragma Unreferenced (Env, Obj);
   begin
      Test2 (Integer (P1));
   end test2;

   -----------
   -- test3 --
   -----------

   procedure test3
     (Env : JNI_Env_Access; Obj : J_Object; P1 : J_Int; P2 : J_Int)
   is
      pragma Unreferenced (Env, Obj);
   begin
      Test3 (Integer (P1), Integer (P2));
   end test3;

   -----------
   -- test4 --
   -----------

   procedure test4 (Env : JNI_Env_Access; Obj : J_Object; P1 : J_Float) is
      pragma Unreferenced (Env, Obj);
   begin
      Test4 (Float (P1));
   end test4;

   -----------
   -- test5 --
   -----------

   procedure test5 (Env : JNI_Env_Access; Obj : J_Object; P1 : J_Double) is
      pragma Unreferenced (Env, Obj);
   begin
      Test5 (Long_Float (P1));
   end test5;

   -----------
   -- test6 --
   -----------

   function test6 (Env : JNI_Env_Access; Obj : J_Object) return J_Int  is
   begin
      return J_Int (Test6);
   end test6;

   -----------
   -- test7 --
   -----------

   procedure test7 (Env : JNI_Env_Access; Obj : J_Object; P1 : J_Object) is
      Cls : J_Class := Get_Object_Class (Env, Obj);
      Method_Id : J_Method_ID :=
                    (Get_Static_Method_ID
                      (Env, Cls,
                       String'("callback7"), "(Ljava/lang/Float;)V"));
   begin
      if Method_Id = J_Null_Method_ID then
         Put_Line ("Method not found: callback7");
         raise Program_Error;
      end if;

      Call_Static_Void_Method_A
        (Env, Cls, Method_Id,
         (1 => (Jobject, L => P1)));
   end test7;

   -----------
   -- test8 --
   -----------

   procedure test8 (Env : JNI_Env_Access; Obj : J_Object; P1 : J_Int) is
      pragma Unreferenced (Env, Obj);
   begin
      Test8 (Integer (P1));
   end test8;

   -----------
   -- test8 --
   -----------

   procedure test8
     (Env : JNI_Env_Access; Obj : J_Object; P1 : J_Int; P2 : J_Int)
   is
      pragma Unreferenced (Env, Obj);
   begin
      Test1.Test8 (Integer (P1), Integer (P2));
   end test8;

end Test1_JNI;
