#!/bin/bash

process_jre=0

usage () {
cat << EOF
Usage: run.sh [options] [test_dirs]

Options:
    -j     process the Java run time

EOF
}

# Parse command line

while getopts "j" opt
do
  case $opt in
    j) process_jre=1;;
    *) echo "Invalid switch: $opt"; usage; exit 1;;
  esac
done
shift `expr $OPTIND - 1`

diff="diff -u"
tests=${@:-*}
testpwd=`pwd`
jvm2ada="$testpwd/../../../src/jvm/bin/jvm2ada"
jre=$testpwd/../jre

export diff
export jvm2ada

# Regenerate the jre mapping

if [ $process_jre -eq 1 ]; then
   cd $jre

   # Generate the Java library mapping for JNI
   if [ ! -d "jni" ]; then
      mkdir jni
   fi
   echo "=== generating the jre mapping for JNI"
   $jvm2ada -w -o jni/ -Luncompressed_jce.jar -Lcharsets.jar -Ljsse.jar rt.jar

   # Generate the Java library mapping for JGNAT
   if [ ! -d "jgnat" ]; then
      mkdir jgnat
   fi
   echo "=== generating the jre mapping for JGNAT"
   $jvm2ada -w -jgnat -o jgnat/ -Luncompressed_jce.jar -Lcharsets.jar -Ljsse.jar rt.jar

   # Postprocess the generated code to workaround jvm2ada limitations.

   cd jgnat

   # java-awt-image-componentsamplemodel.ads:
   #    Rename field numBands into numBands_C because the parent type of
   #    ComponentSampleModel has also a field named numBands.
   cp java-awt-image-componentsamplemodel.ads java-awt-image-componentsamplemodel.ads.old
   cat java-awt-image-componentsamplemodel.ads.old | \
     sed -e 's/NumBands/NumBands_C/' > java-awt-image-componentsamplemodel.ads

   cd ..

fi

# Run each test

for dir in $tests; do
   cd $testpwd

   if [ -d $dir -a $dir != 'CVS' ]; then
      cd $dir

      if [ -f test.sh ]; then
         out=out.$$

         sh test.sh > $out 2>&1
         status=$?

         if [ $status -ne 0 -o -s $out ]; then
            echo "--- $dir"
            cat $out
         else
            echo "+++ $dir"
         fi

         rm $out
      else
         echo "=== no test.sh in $dir"
      fi
   fi
done

